package com.bxm.newidea.component.redisson.config;

import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.proxy.Enhancer;

/**
 * local环境使用延迟加载
 *
 * @author liujia
 * @date 7/22/21 7:23 PM
 **/
@Slf4j
public class RedissonClientFactoryBean implements FactoryBean<RedissonClient> {

    private RedissonConfigurationProperties properties;

    private RedissonClientHolder redissonClientHolder;

    @Value("${spring.profiles.active:LOCAL}")
    private String profile;

    public RedissonClientFactoryBean(RedissonConfigurationProperties properties,
                                     RedissonClientHolder redissonClientHolder) {
        this.properties = properties;
        this.redissonClientHolder = redissonClientHolder;
    }

    @Override
    public RedissonClient getObject() throws Exception {
        // 本地环境使用延迟加载
        if (StringUtils.equalsAnyIgnoreCase(profile, "LOCAL", "TEST")) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(RedissonClient.class);
            enhancer.setCallback(new RedissonMethodInterceptor(redissonClientHolder));

            return (RedissonClient) enhancer.create();
        }

        return redissonClientHolder.get();
    }


    @Override
    public Class<?> getObjectType() {
        return RedissonClient.class;
    }

}
