package com.bxm.newidea.component.schedule.handler;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.schedule.constant.CommonConstant;
import com.bxm.newidea.component.schedule.param.ExecutorParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.lang.reflect.Method;

/**
 * 任务Handler（Bean模式）
 * <p>
 * 开发步骤：
 * 1、继承"IJobHandler"：“com.xxl.job.core.handler.IJobHandler”；
 * 2、注册到Spring容器：添加“@Component”注解，被Spring容器扫描为Bean实例；
 * 3、注册到执行器工厂：添加“@JobHandler(value="自定义jobhandler名称")”注解，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 4、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 */
@JobHandler(value = CommonConstant.HANDLER_NAME)
@Component
public class BeanByNameHandler extends IJobHandler {

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public ReturnT<String> execute(String param) throws Exception {
        XxlJobLogger.log(param);
        if (StringUtils.isBlank(param)) {
            return new ReturnT<>(ReturnT.FAIL_CODE, "参数不能为空！");
        }

        ExecutorParam executorParam = JSON.parseObject(param, ExecutorParam.class);
        if (StringUtils.isBlank(executorParam.getBeanName()) || StringUtils.isBlank(executorParam.getMethodName())) {
            return new ReturnT<>(ReturnT.FAIL_CODE, "参数格式错误，缺少bean名称或方法名");
        }

        Object o;
        try {
            o = applicationContext.getBean(executorParam.getBeanName());
        } catch (Exception e) {
            return new ReturnT<>(ReturnT.FAIL_CODE, "类" + executorParam.getBeanName() + "不存在");
        }

        Method method;
        try {
            if (StringUtils.isBlank(executorParam.getParams())) {
                method = o.getClass().getMethod(executorParam.getMethodName());
                method.invoke(o);
            } else {
                method = o.getClass().getMethod(executorParam.getMethodName(), String.class);
                method.invoke(o, executorParam.getParams());
            }
        } catch (Exception e) {
            return new ReturnT<>(ReturnT.FAIL_CODE, "方法" + executorParam.getMethodName() + "调用失败");
        }

        return new ReturnT<>(ReturnT.SUCCESS_CODE, "调用job成功");
    }

}
