package com.bxm.newidea.component.schedule.api;

import com.bxm.newidea.component.schedule.param.ExtraJob;
import com.bxm.newidea.component.schedule.param.AbstractJob;

public interface ScheduleService {

    /**
     * 简单添加任务，功能参数较少
     *
     * @param abstractJob 任务参数
     */
    void simpleAdd(AbstractJob abstractJob);

    /**
     * 复杂添加任务，功能参数较多
     *
     * @param extraJob 任务参数
     */
    void complexAdd(ExtraJob extraJob);

    /**
     * 简单更新任务，功能参数较少
     *
     * @param abstractJob 任务参数
     */
    void simpleUpdate(AbstractJob abstractJob);

    /**
     * 复杂更新任务，功能参数较多
     *
     * @param extraJob 执行器所需参数
     */
    void complexUpdate(ExtraJob extraJob);

    /**
     * 移除任务
     *
     * @param jobName 任务名称
     */
    void remove(String jobName);

}
