package com.bxm.newidea.component.schedule.api.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.schedule.api.ScheduleService;
import com.bxm.newidea.component.schedule.config.XxlJobConfig;
import com.bxm.newidea.component.schedule.constant.CommonConstant;
import com.bxm.newidea.component.schedule.constant.ExecutorRouteStrategyEnum;
import com.bxm.newidea.component.schedule.facade.ScheduleFeignService;
import com.bxm.newidea.component.schedule.param.ExecutorParam;
import com.bxm.newidea.component.schedule.param.ExtraJob;
import com.bxm.newidea.component.schedule.param.AbstractJob;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class ScheduleServiceImpl implements ScheduleService {

    @Resource
    private XxlJobConfig xxlJobConfig;

    @Resource
    private ScheduleFeignService scheduleFeignService;

    @Override
    public void simpleAdd(AbstractJob abstractJob) {
        scheduleFeignService.add(abstractJob.getJobName(),
                abstractJob.getJobCron(),
                abstractJob.getJobDesc(),
                xxlJobConfig.getAppName(),
                CommonConstant.HANDLER_NAME,
                JSON.toJSONString(new ExecutorParam(abstractJob.getTaskName(), abstractJob.getParams())),
                ExecutorRouteStrategyEnum.ROUND.name(),
                ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name(),
                xxlJobConfig.getAppName());
    }

    @Override
    public void complexAdd(ExtraJob extraJob) {
        scheduleFeignService.add(extraJob.getJobName(),
                extraJob.getJobCron(),
                extraJob.getJobDesc(),
                xxlJobConfig.getAppName(),
                CommonConstant.HANDLER_NAME,
                JSON.toJSONString(new ExecutorParam(extraJob.getTaskName(), extraJob.getParams())),
                extraJob.getExecutorRouteStrategy(),
                extraJob.getExecutorBlockStrategy(),
                extraJob.getAuthor());
    }

    @Override
    public void simpleUpdate(AbstractJob abstractJob) {
        scheduleFeignService.update(abstractJob.getJobName(),
                abstractJob.getJobCron(),
                abstractJob.getJobDesc(),
                xxlJobConfig.getAppName(),
                CommonConstant.HANDLER_NAME,
                JSON.toJSONString(new ExecutorParam(abstractJob.getTaskName(), abstractJob.getParams())),
                ExecutorRouteStrategyEnum.ROUND.name(),
                ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name(),
                xxlJobConfig.getAppName());
    }

    @Override
    public void complexUpdate(ExtraJob extraJob) {
        scheduleFeignService.update(extraJob.getJobName(),
                extraJob.getJobCron(),
                extraJob.getJobDesc(),
                xxlJobConfig.getAppName(),
                CommonConstant.HANDLER_NAME,
                JSON.toJSONString(new ExecutorParam(extraJob.getTaskName(), extraJob.getParams())),
                extraJob.getExecutorRouteStrategy(),
                extraJob.getExecutorBlockStrategy(),
                extraJob.getAuthor());
    }

    @Override
    public void remove(String jobName) {
        scheduleFeignService.remove(jobName);
    }

}

