/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.api.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.schedule.api.ScheduleService;
import com.bxm.newidea.component.schedule.config.XxlJobConfig;
import com.bxm.newidea.component.schedule.constant.RouteStrategyEnum;
import com.bxm.newidea.component.schedule.facade.ScheduleFeignService;
import com.bxm.newidea.component.schedule.param.AbstractJob;
import com.bxm.newidea.component.schedule.param.ExecutorParam;
import com.bxm.newidea.component.schedule.param.ExtraJob;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    @Resource
    private XxlJobConfig xxlJobConfig;
    @Resource
    private ScheduleFeignService scheduleFeignService;

    @Override
    public void simpleAdd(AbstractJob abstractJob) {
        if (this.isNotValid(abstractJob)) {
            return;
        }
        this.scheduleFeignService.add(abstractJob.getJobName(), abstractJob.getJobCron(), abstractJob.getJobDesc(), this.xxlJobConfig.getAppName(), "beanByNameHandler", JSON.toJSONString((Object)new ExecutorParam(abstractJob.getTaskName(), abstractJob.getParams())), RouteStrategyEnum.ROUND.name(), ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name(), this.xxlJobConfig.getAppName());
    }

    @Override
    public void complexAdd(ExtraJob extraJob) {
        if (this.isNotValid(extraJob)) {
            return;
        }
        this.scheduleFeignService.add(extraJob.getJobName(), extraJob.getJobCron(), extraJob.getJobDesc(), this.xxlJobConfig.getAppName(), "beanByNameHandler", JSON.toJSONString((Object)new ExecutorParam(extraJob.getTaskName(), extraJob.getParams())), extraJob.getRouteStrategy().name(), extraJob.getBlockStrategy().name(), extraJob.getAuthor());
    }

    @Override
    public void simpleUpdate(AbstractJob abstractJob) {
        if (this.isNotValid(abstractJob)) {
            return;
        }
        this.scheduleFeignService.update(abstractJob.getJobName(), abstractJob.getJobCron(), abstractJob.getJobDesc(), this.xxlJobConfig.getAppName(), "beanByNameHandler", JSON.toJSONString((Object)new ExecutorParam(abstractJob.getTaskName(), abstractJob.getParams())), RouteStrategyEnum.ROUND.name(), ExecutorBlockStrategyEnum.SERIAL_EXECUTION.name(), this.xxlJobConfig.getAppName());
    }

    @Override
    public void complexUpdate(ExtraJob extraJob) {
        if (this.isNotValid(extraJob)) {
            return;
        }
        this.scheduleFeignService.update(extraJob.getJobName(), extraJob.getJobCron(), extraJob.getJobDesc(), this.xxlJobConfig.getAppName(), "beanByNameHandler", JSON.toJSONString((Object)new ExecutorParam(extraJob.getTaskName(), extraJob.getParams())), extraJob.getRouteStrategy().name(), extraJob.getBlockStrategy().name(), extraJob.getAuthor());
    }

    @Override
    public void remove(String jobName) {
        if (StringUtils.isBlank((String)jobName)) {
            return;
        }
        this.scheduleFeignService.remove(jobName);
    }

    private boolean isNotValid(AbstractJob abstractJob) {
        if (null == abstractJob) {
            return true;
        }
        return StringUtils.isBlank((String)abstractJob.getJobName()) || StringUtils.isBlank((String)abstractJob.getJobCron()) || StringUtils.isBlank((String)abstractJob.getJobDesc()) || StringUtils.isBlank((String)abstractJob.getTaskName());
    }

    private boolean isNotValid(ExtraJob extraJob) {
        if (null == extraJob) {
            return true;
        }
        return StringUtils.isBlank((String)extraJob.getJobName()) || StringUtils.isBlank((String)extraJob.getJobCron()) || StringUtils.isBlank((String)extraJob.getJobDesc()) || StringUtils.isBlank((String)extraJob.getTaskName()) || StringUtils.isBlank((String)extraJob.getAuthor()) || null == extraJob.getRouteStrategy() || null == extraJob.getBlockStrategy();
    }
}

