package com.bxm.newidea.component.schedule.rpc;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.config.ExecutorParam;
import com.bxm.newidea.component.schedule.config.XxlJobConfiguration;
import com.bxm.newidea.component.schedule.constant.CommonConstant;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

@Service
@Slf4j
public class ScheduleServiceImpl implements ScheduleService, ApplicationContextAware, ApplicationListener<ContextRefreshedEvent> {

    @Resource
    private XxlJobConfiguration xxlJobConfiguration;

    @Resource
    private ScheduleFeignService scheduleFeignService;

    private ApplicationContext applicationContext;

    @Override
    public boolean push(ScheduleTask task) {
        if (validate(task)) {
            ResponseEntity<Boolean> response = scheduleFeignService.add(task.taskName(),
                    task.cron(),
                    task.description(),
                    xxlJobConfiguration.getAppName(),
                    CommonConstant.HANDLER_NAME,
                    buildParam(task),
                    task.routeStrategy().name(),
                    task.blockStrategy().name(),
                    xxlJobConfiguration.getAppName());

            return response.hasBody() && null != response.getBody() && response.getBody();
        }
        return false;
    }

    private String buildParam(ScheduleTask task) {
        return JSON.toJSONString(new ExecutorParam(task.taskName(), task.callbackParam()));
    }

    private boolean validate(ScheduleTask task) {
        boolean pass = true;
        if (task.callback() == null) {
            log.error("任务回调服务类未设置");
            pass = false;
        }
        if (!applicationContext.containsBean(task.callback().beanName())) {
            log.error("任务回调服务类未设置到Spring上下文");
            pass = false;
        }
        if (null == task.cron()) {
            log.error("任务未设置执行时间");
            pass = false;
        }

        return pass;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        //获取spring中配置的调度任务
        Map<String, ScheduleTask> taskMap = applicationContext.getBeansOfType(ScheduleTask.class);
        if (taskMap.size() > 0) {
            taskMap.values().forEach(this::push);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

