package com.bxm.newidea.component.schedule.task;

import com.bxm.newidea.component.schedule.constant.RouteStrategyEnum;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import org.apache.commons.lang.StringUtils;

import java.util.UUID;

/**
 * 调度任务接口，用于定义调度任务拥有的属性
 * @author zhengxiaofeng
 */
public interface ScheduleTask {

    /**
     * 调度任务名称，用于在调度平台区分任务信息
     * @return 任务名称
     */
    default String taskName() {
        return UUID.randomUUID().toString();
    }

    /**
     * 获取调度任务的执行周期
     * 单次执行和周期执行的任务均用cron表达式代替
     * 单次执行任务可使用{@link com.bxm.newidea.component.schedule.utils.CronUtils}进行处理
     * @return 执行周期
     */
    String cron();

    /**
     * 任务描述，说明调度任务的作用
     * @return 任务描述
     */
    default String description() {
        return StringUtils.EMPTY;
    }

    /**
     * 调度任务的回调接口，在到达任务执行周期时回调
     * @return 回调服务
     */
    TaskCallback callback();

    /**
     * 回调时携带的参数，需要在创建调度任务时传递
     * 支持使用Json结构
     * @return 业务参数
     */
    default String callbackParam() {
        return StringUtils.EMPTY;
    }

    ;

    /**
     * 任务路由策略，在执行节点存在多个时，决定如何选择执行点
     * @return 路由策略
     */
    default RouteStrategyEnum routeStrategy() {
        return RouteStrategyEnum.ROUND;
    }

    ;

    /**
     * 阻塞策略，在任务执行时前一个任务尚未完成，后续的任务如何调度
     * @return 阻塞策略
     */
    default ExecutorBlockStrategyEnum blockStrategy() {
        return ExecutorBlockStrategyEnum.SERIAL_EXECUTION;
    }

    ;

    /**
     * 调度任务的创建者
     * 不怕被喷的人留下名来
     * @return 作者
     */
    default String author() {
        return StringUtils.EMPTY;
    }
}
