package com.bxm.newidea.component.schedule.task;

import com.xxl.job.core.biz.model.ReturnT;

/**
 * 调度中心回调接口，当推送的调度到达执行周期时，将回调业务服务来触发
 * 该接口的实现类必须注册到Spring ApplicationContext
 */
public interface TaskCallback<T> {

    /**
     * 业务执行方法，回调被触发时执行
     * @param param 创建调度任务时设置的参数，Json结构返回
     * @return 执行结果
     */
    ReturnT<String> execute(String param);

    /**
     * 调度任务创建时传递的参数解码类型，如果为空将直接返回字符串
     * @return 参数类信息
     */
    Class<T> paramClass();

    /**
     * 回调接口在Spring中定义的Bean名称
     * 如果自定义了类名，需要覆盖此方法
     * @return beanName
     */
    default String beanName() {
        return this.getClass().getSimpleName();
    }
}
