package com.bxm.newidea.component.schedule.builder;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.schedule.constant.RouteStrategyEnum;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import org.apache.commons.lang.StringUtils;

import java.util.UUID;


public class BaseTask extends TaskAttribute implements ScheduleTask, TaskCallback {

    @Override
    public String taskName() {
        if (StringUtils.isBlank(taskName)) {
            return UUID.randomUUID().toString();
        }
        return this.taskName;
    }

    @Override
    public String author() {
        return this.author;
    }

    @Override
    public String cron() {
        return this.cron;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public TaskCallback<?> callback() {
        return this.callback;
    }

    @Override
    public String callbackParam() {
        if (null == this.param) {
            return StringUtils.EMPTY;
        }
        return JSON.toJSONString(param);
    }

    @Override
    public RouteStrategyEnum routeStrategy() {
        if (null == this.routeStrategy) {
            return RouteStrategyEnum.ROUND;
        }
        return this.routeStrategy;
    }

    @Override
    public ExecutorBlockStrategyEnum blockStrategy() {
        if (null == this.blockStrategy) {
            return ExecutorBlockStrategyEnum.SERIAL_EXECUTION;
        }
        return blockStrategy;
    }

    @Override
    public ReturnT<String> execute(String param) {
        if (null != this.callback) {
            return this.callback.execute(param);
        }
        return ReturnT.FAIL;
    }

    @Override
    public Class paramClass() {
        if (null != param) {
            return param.getClass();
        }
        return null;
    }
}
