package com.bxm.newidea.component.schedule.task;

import com.alibaba.fastjson.JSON;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.ParameterizedType;

@Slf4j
public abstract class AbstractTaskCallback<T> implements TaskCallback<T> {

    @Override
    public ReturnT<String> execute(String param) {
        log.debug("执行任务回调，回调参数：[{}]", param);
        ReturnT<String> result;
        try {
            T parseParam = null;
            if (null != paramClass()) {
                parseParam = JSON.parseObject(param, paramClass());
            }

            result = service(parseParam);
        } catch (Exception e) {
            log.error("定时任务执行失败：" + e.getMessage(), e);
            return ReturnT.FAIL;
        }
        log.debug("定时任务执行结果：[{}]", result);
        return result;
    }

    /**
     * 由于泛型擦除问题，该方法不一定适用于所有情况，若无法适用，则在子类中重写该方法
     *
     * @return 泛型的class
     */
    @Override
    public Class<T> paramClass() {
        return (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    /**
     * 执行定时任务的业务逻辑
     * @param param 定时任务创建时传递的参数
     * @return 定时任务执行结果
     */
    protected abstract ReturnT<String> service(T param);
}
