/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.builder;

import com.bxm.newidea.component.schedule.builder.OnceTask;
import com.bxm.newidea.component.schedule.builder.TaskAttribute;
import com.bxm.newidea.component.schedule.constant.RouteStrategyEnum;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.schedule.utils.CronUtils;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import java.util.Date;

public class OnceTaskBuilder
extends TaskAttribute {
    private Date fireTime;

    private OnceTaskBuilder() {
    }

    public static OnceTaskBuilder builder(String taskName, Date fireTime, TaskCallback callback) {
        OnceTaskBuilder task = new OnceTaskBuilder();
        task.fireTime = fireTime;
        task.taskName = taskName;
        task.callback = callback;
        return task;
    }

    public static OnceTaskBuilder builder(Date fireTime, TaskCallback callback) {
        OnceTaskBuilder task = new OnceTaskBuilder();
        task.fireTime = fireTime;
        task.callback = callback;
        return task;
    }

    public OnceTask build() {
        OnceTask task = new OnceTask();
        if (null != this.fireTime) {
            task.cron = CronUtils.formatDateToCron(this.fireTime);
        }
        task.taskName = this.taskName;
        task.callback = this.callback;
        task.description = this.description;
        task.param = this.param;
        task.routeStrategy = this.routeStrategy;
        task.blockStrategy = this.blockStrategy;
        task.author = this.author;
        return task;
    }

    public OnceTaskBuilder taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public OnceTaskBuilder fireTime(Date fireTime) {
        this.fireTime = fireTime;
        return this;
    }

    public OnceTaskBuilder description(String description) {
        this.description = description;
        return this;
    }

    public OnceTaskBuilder author(String author) {
        this.author = author;
        return this;
    }

    public OnceTaskBuilder callback(TaskCallback callback) {
        this.callback = callback;
        return this;
    }

    public OnceTaskBuilder callbackParam(Object param) {
        this.param = param;
        return this;
    }

    public OnceTaskBuilder routeStrategy(RouteStrategyEnum routeStrategy) {
        this.routeStrategy = routeStrategy;
        return this;
    }

    public OnceTaskBuilder blockStrategy(ExecutorBlockStrategyEnum blockStrategy) {
        this.blockStrategy = blockStrategy;
        return this;
    }
}

