/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.spring.cloud.netflix.eureka.client;

import com.bxm.component.spring.cloud.netflix.eureka.client.EurekaClientServiceRegistration;
import com.bxm.component.spring.cloud.netflix.eureka.client.EurekaClientServiceRegistryProperties;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"component.spring.cloud.service-registry.custom.enabled"}, matchIfMissing=true)
public class EurekaClientServiceRegisterConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
    public EurekaClientServiceRegistration eurekaClientServiceRegistration(ApplicationContext context, EurekaRegistration registration, CloudEurekaInstanceConfig instanceConfig, ApplicationInfoManager applicationInfoManager, EurekaClientServiceRegistryProperties properties) {
        if (Objects.equals(instanceConfig.getInitialStatus(), InstanceInfo.InstanceStatus.UP) && instanceConfig instanceof EurekaInstanceConfigBean) {
            ((EurekaInstanceConfigBean)instanceConfig).setInitialStatus(InstanceInfo.InstanceStatus.STARTING);
        }
        return new EurekaClientServiceRegistration(context, registration, applicationInfoManager, properties);
    }
}

