package com.bxm.component.spring;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author Gonzo
 * @date 2019-12-04 16:12
 */
@Configuration
public class ShutdownConfiguration {

    @Bean
    @ConditionalOnProperty(value = "component.spring.custom-shutdown-hook.enabled", matchIfMissing = true)
    public ShutdownHook shutdownHook(ApplicationContext applicationContext) {
        return new ShutdownHook(applicationContext);
    }

}
