/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.rule;

import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.exception.ExcutorException;
import com.bxm.newidea.component.rule.IRule;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class RuleGroupExecutor
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(RuleGroupExecutor.class);
    private Map<String, List<IRule>> groupRuleMap = new HashMap<String, List<IRule>>();
    private ThreadLocal<List<Class<? extends IRule>>> choiceRuleThreadLocal = new ThreadLocal();
    private ThreadLocal<List<Class<? extends IRule>>> skipRuleThreadLocal = new ThreadLocal();

    public RuleGroupExecutor choice(Class<? extends IRule> filterClass) {
        return this.setThreadLocal(filterClass, this.choiceRuleThreadLocal);
    }

    public RuleGroupExecutor skip(Class<? extends IRule> filterClass) {
        return this.setThreadLocal(filterClass, this.skipRuleThreadLocal);
    }

    private RuleGroupExecutor setThreadLocal(Class<? extends IRule> filterClass, ThreadLocal<List<Class<? extends IRule>>> threadLocal) {
        List<Class<? extends IRule>> ruleList = threadLocal.get();
        if (null == ruleList) {
            ruleList = new ArrayList<Class<? extends IRule>>();
        }
        ruleList.add(filterClass);
        threadLocal.set(ruleList);
        return this;
    }

    public <T> boolean apply(String groupName, T context) {
        List<IRule> rules = this.groupRuleMap.get(groupName);
        if (null == rules) {
            log.error("\u4e0d\u5b58\u5728[{}]\u5bf9\u5e94\u7684\u903b\u8f91\u89c4\u5219\u5206\u7ec4", (Object)groupName);
            return false;
        }
        List<Class<? extends IRule>> choiceRuleList = this.choiceRuleThreadLocal.get();
        List<Class<? extends IRule>> skipRuleList = this.skipRuleThreadLocal.get();
        try {
            for (IRule rule : rules) {
                if (null != skipRuleList && skipRuleList.contains(rule.getClass()) || null != choiceRuleList && choiceRuleList.size() > 0 && !choiceRuleList.contains(rule.getClass())) continue;
                if (rule.apply(context)) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExcutorException("\u4e1a\u52a1\u903b\u8f91\u89c4\u5219\u6267\u884c\u5931\u8d25\uff0c\u89c4\u5219\u5206\u7ec4\uff1a" + groupName, e);
        }
        finally {
            this.choiceRuleThreadLocal.remove();
            this.skipRuleThreadLocal.remove();
        }
        return true;
    }

    public void run(ApplicationArguments args) throws Exception {
        for (IRule iRule : SpringContextHolder.getBeans(IRule.class)) {
            RuleBean annotation = (RuleBean)AnnotationUtils.findAnnotation(iRule.getClass(), RuleBean.class);
            if (null == annotation) {
                log.warn("[{}]\u672a\u63d0\u4f9bRuleBean\u6ce8\u89e3", (Object)iRule.getClass().getSimpleName());
                continue;
            }
            List<IRule> rules = this.groupRuleMap.get(annotation.group());
            if (rules == null) {
                rules = new ArrayList<IRule>();
            }
            rules.add(iRule);
            this.groupRuleMap.put(annotation.group(), rules);
        }
        for (List list : this.groupRuleMap.values()) {
            OrderComparator.sort((List)list);
        }
    }
}

