/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.filter;

import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.exception.ExcutorException;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class FilterChainExecutor
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(FilterChainExecutor.class);
    private Map<String, List<IFilter>> groupFilterMap = new HashMap<String, List<IFilter>>();
    private ThreadLocal<List<Class<? extends IFilter>>> choiceFilterThreadLocal = new ThreadLocal();
    private ThreadLocal<List<Class<? extends IFilter>>> skipFilterThreadLocal = new ThreadLocal();

    public FilterChainExecutor choice(Class<? extends IFilter> filterClass) {
        return this.setThreadLocal(filterClass, this.choiceFilterThreadLocal);
    }

    public FilterChainExecutor skip(Class<? extends IFilter> filterClass) {
        return this.setThreadLocal(filterClass, this.skipFilterThreadLocal);
    }

    private FilterChainExecutor setThreadLocal(Class<? extends IFilter> filterClass, ThreadLocal<List<Class<? extends IFilter>>> threadLocal) {
        List<Class<? extends IFilter>> filterList = threadLocal.get();
        if (null == filterList) {
            filterList = new ArrayList<Class<? extends IFilter>>();
        }
        filterList.add(filterClass);
        threadLocal.set(filterList);
        return this;
    }

    public <T> void doFilter(String group, T context) {
        this.execFilter(group, context, false);
    }

    public <T> void parallelDoFilter(String group, T context) {
        this.execFilter(group, context, true);
    }

    private <T> void execFilter(String group, T context, boolean parallel) {
        List<IFilter> filters = this.groupFilterMap.get(group);
        if (null == filters) {
            return;
        }
        List<Class<? extends IFilter>> choiceFilterList = this.choiceFilterThreadLocal.get();
        List<Class<? extends IFilter>> skipFilterList = this.skipFilterThreadLocal.get();
        long start = System.currentTimeMillis();
        try {
            if (parallel) {
                ((Stream)filters.stream().parallel()).forEach(filter -> {
                    if (filter.supportParallel()) {
                        this.internalFilter((IFilter)filter, context, choiceFilterList, skipFilterList);
                    }
                });
                filters.forEach(filter -> {
                    if (!filter.supportParallel()) {
                        this.internalFilter((IFilter)filter, context, choiceFilterList, skipFilterList);
                    }
                });
            } else {
                for (IFilter filter2 : filters) {
                    this.internalFilter(filter2, context, choiceFilterList, skipFilterList);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExcutorException("\u8fc7\u6ee4\u5668\u6267\u884c\u5931\u8d25,\u7b56\u7565\u5206\u7ec4\uff1a" + group, e);
        }
        finally {
            this.choiceFilterThreadLocal.remove();
            this.skipFilterThreadLocal.remove();
        }
        long expense = System.currentTimeMillis() - start;
        if (log.isDebugEnabled()) {
            log.debug("\u903b\u8f91\u5206\u7ec4[{}]\u6267\u884c\u603b\u8017\u65f6\uff1a{}", (Object)group, (Object)expense);
        }
        if (expense > 100L) {
            log.info("\u903b\u8f91\u5206\u7ec4[{}]\u6267\u884c\u603b\u8017\u65f6\uff1a{}\uff0c\u8d85\u8fc7100ms\uff0c\u9700\u8981\u91cd\u70b9\u5173\u6ce8", (Object)group, (Object)expense);
        }
    }

    private <T> void internalFilter(IFilter filter, T context, List<Class<? extends IFilter>> choiceFilterList, List<Class<? extends IFilter>> skipFilterList) {
        if (null != skipFilterList && skipFilterList.contains(filter.getClass())) {
            return;
        }
        if (null != choiceFilterList && choiceFilterList.size() > 0 && !choiceFilterList.contains(filter.getClass())) {
            return;
        }
        long start = System.currentTimeMillis();
        filter.doFilter(context);
        if (log.isDebugEnabled()) {
            log.debug("\u8fc7\u6ee4\u5668[{}]\u6267\u884c\u8017\u8d39\uff1a{}ms", (Object)filter.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - start));
        }
    }

    public void run(ApplicationArguments args) {
        for (IFilter iFilter : SpringContextHolder.getBeans(IFilter.class)) {
            FilterBean annotation = (FilterBean)AnnotationUtils.findAnnotation(iFilter.getClass(), FilterBean.class);
            if (null == annotation) {
                log.warn("[{}]\u672a\u63d0\u4f9bFilterBean\u6ce8\u89e3", (Object)iFilter.getClass().getSimpleName());
                continue;
            }
            List<IFilter> filters = this.groupFilterMap.get(annotation.group());
            if (filters == null) {
                filters = new ArrayList<IFilter>();
            }
            filters.add(iFilter);
            this.groupFilterMap.put(annotation.group(), filters);
        }
        for (List list : this.groupFilterMap.values()) {
            OrderComparator.sort((List)list);
        }
    }
}

