//package com.bxm.newidea.component.event;
//
//import com.bxm.newidea.component.config.SpringExtendConfigurationProperties;
//import com.bxm.newidea.component.thread.NamedThreadFactory;
//import com.lmax.disruptor.*;
//import com.lmax.disruptor.dsl.Disruptor;
//import com.lmax.disruptor.dsl.ProducerType;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.DisposableBean;
//
//import java.util.concurrent.Executor;
//
///**
// * @author liujia
// * @date 11/10/21 8:43 PM
// **/
//@Slf4j
//public class ApplicationEventDisruptorExecutor implements Executor, DisposableBean {
//
//    private Disruptor<ApplicationEventWrapper> disruptor;
//
//    private ApplicationEventTranslatorOneArg translator;
//
//    public ApplicationEventDisruptorExecutor(SpringExtendConfigurationProperties properties) {
//        SpringExtendConfigurationProperties.DisruptorConfig disruptorConfig = properties.getDisruptorConfig();
//
//        NamedThreadFactory threadFactory = new NamedThreadFactory("application-event-executor", true);
//
//        WaitStrategy waitStrategy = new YieldingWaitStrategy();
//
//        EventFactory<ApplicationEventWrapper> eventFactory = ApplicationEventWrapper::new;
//
//        disruptor = new Disruptor<>(eventFactory,
//                disruptorConfig.getCoreSize(),
//                threadFactory,
//                ProducerType.SINGLE,
//                waitStrategy);
//
//        disruptor.setDefaultExceptionHandler(new ApplicationEventExceptionHandler());
//
//        WorkHandler<ApplicationEventWrapper>[] handlerArray = new ApplicationWorkHandler[disruptorConfig.getWorkHandleSize()];
//        for (int i = 0; i < disruptorConfig.getWorkHandleSize(); i++) {
//            handlerArray[i] = new ApplicationWorkHandler();
//        }
//
//        disruptor.handleEventsWithWorkerPool(handlerArray);
//
//        disruptor.start();
//        translator = new ApplicationEventTranslatorOneArg();
//    }
//
//    @Override
//    public void execute(Runnable command) {
//        disruptor.publishEvent(translator, command);
//    }
//
//    @Override
//    public void destroy() {
//        disruptor.shutdown();
//    }
//
//    class ApplicationEventTranslatorOneArg implements EventTranslatorOneArg<ApplicationEventWrapper, Runnable> {
//        @Override
//        public void translateTo(ApplicationEventWrapper event, long sequence, Runnable arg0) {
//            event.setRunnable(arg0);
//        }
//    }
//
//    class ApplicationEventExceptionHandler implements ExceptionHandler<ApplicationEventWrapper> {
//        @Override
//        public void handleEventException(Throwable ex, long sequence, ApplicationEventWrapper event) {
//            log.error(ex.getMessage(), ex);
//        }
//
//        @Override
//        public void handleOnStartException(Throwable ex) {
//            log.error(ex.getMessage(), ex);
//        }
//
//        @Override
//        public void handleOnShutdownException(Throwable ex) {
//            log.error(ex.getMessage(), ex);
//        }
//    }
//
//    class ApplicationWorkHandler implements WorkHandler<ApplicationEventWrapper> {
//
//        @Override
//        public void onEvent(ApplicationEventWrapper event) {
//            if (null != event.getRunnable()) {
//                event.getRunnable().run();
//                event.clear();
//            }
//        }
//    }
//}
