/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.strategy;

import com.bxm.newidea.component.annotations.StrategyBean;
import com.bxm.newidea.component.strategy.IStrategy;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class StrategyExecutor
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(StrategyExecutor.class);
    private Map<String, List<IStrategy>> groupStrategyMap = new HashMap<String, List<IStrategy>>();

    public <T> void execute(String groupName, T context, boolean multiMatch) {
        List<IStrategy> strategies = this.groupStrategyMap.get(groupName);
        if (null == strategies) {
            log.error("\u4e0d\u5b58\u5728[{}]\u5bf9\u5e94\u7684\u7b56\u7565\u903b\u8f91\u5206\u7ec4", (Object)groupName);
            return;
        }
        for (IStrategy strategy : strategies) {
            if (!strategy.match(context)) continue;
            strategy.execute(context);
            if (multiMatch) continue;
        }
    }

    public <T> void execute(String groupName, T context) {
        this.execute(groupName, context, false);
    }

    public void run(ApplicationArguments args) {
        for (IStrategy iStrategy : SpringContextHolder.getBeans(IStrategy.class)) {
            StrategyBean annotation = (StrategyBean)AnnotationUtils.findAnnotation(iStrategy.getClass(), StrategyBean.class);
            if (null == annotation) {
                log.warn("[{}]\u672a\u63d0\u4f9bStrategyBean\u6ce8\u89e3", (Object)iStrategy.getClass().getSimpleName());
                continue;
            }
            List<IStrategy> strategies = this.groupStrategyMap.get(annotation.group());
            if (strategies == null) {
                strategies = new ArrayList<IStrategy>();
            }
            strategies.add(iStrategy);
            this.groupStrategyMap.put(annotation.group(), strategies);
        }
        for (List list : this.groupStrategyMap.values()) {
            OrderComparator.sort((List)list);
        }
    }
}

