package com.bxm.component.tbk.order.model.enums;

import java.util.Objects;

/**
 * 淘客站点id
 * @author Gonzo
 * @date  2020-05-06 20:34
 * @since 2.0.0
 */
public enum BusinesSiteId {

    /**
     * 趣淘金推广位id
     */
    FOSSICKER("597650089", "趣淘金"),

    /**
     * 万事通推广位id
     */
    LOCAL_NEWS("1620200004", "万事通"),
    ;

    private String id;

    private String des;

    BusinesSiteId(String id, String des) {
        this.id = id;
        this.des = des;
    }

    public String getId() {
        return id;
    }

    public String getDes() {
        return des;
    }

    public static BusinesSiteId getById(String id) {
        for (BusinesSiteId value : BusinesSiteId.values()) {
            if (Objects.equals(value.getId(), id)) {
                return value;
            }
        }

        return null;
    }
}
