package com.bxm.component.tbk.order.timer;

import com.bxm.component.tbk.order.config.OrderTimerConfigProperties;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.service.OrderCommissionSettleService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 每月定时结算购物订单的返佣
 * @author Gonzo
 * @date  2020-05-03 17:05
 * @since 2.0.0
 */
@Component
@Slf4j
@AllArgsConstructor
public class OrderCommissionSettleTask extends AbstractCronTask<String>  {

    private final OrderCommissionSettleService orderCommissionSettleService;

    private final OrderTimerConfigProperties orderTimerConfigProperties;

    private final TbkOpenOrderProperties tbkOpenOrderProperties;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("执行任务: {} 开始", taskName());

        try {
            orderCommissionSettleService.payCashForLastMonthOrder();
            log.info("执行任务: {} 结束", taskName());
        } catch (Exception e) {
            log.error("执行任务: {} 失败", taskName(), e);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "定时返利结算" + tbkOpenOrderProperties.getSite();
    }

    @Override
    public String cron() {

        if (log.isDebugEnabled()) {
            log.debug("{}: {}", taskName(), orderTimerConfigProperties.getOrderCommissionSettleCron());
        }
        return orderTimerConfigProperties.getOrderCommissionSettleCron();
    }
}
