package com.bxm.component.tbk.order.timer;

import com.bxm.component.tbk.order.config.OrderTimerConfigProperties;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.service.PullOrderService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 每隔一段时间拉拉取淘宝订单
 * @author: Gonzo
 * @date  2020-05-02 10:21
 * @since 2.0.0
 */
@Slf4j
@Component
@AllArgsConstructor
public class PullOrderTask extends AbstractCronTask<String> {

    private final PullOrderService pullOrderService;

    private final OrderTimerConfigProperties orderTimerConfigProperties;

    private final TbkOpenOrderProperties tbkOpenOrderProperties;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("执行任务: {} 开始", taskName());

        try {
            log.info("拉取渠道订单开始");
            pullOrderService.pullOrder();
            log.info("拉取渠道订单结束");

            log.info("拉取常规订单开始");
            pullOrderService.pullGeneralOrder();
            log.info("拉取常规订单结束");

            log.info("执行任务: {} 结束", taskName());
        } catch (Exception e) {

            log.error("执行任务: {} 失败", taskName(), e);
            return ReturnT.FAIL;
        }

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "拉取订单信息" + tbkOpenOrderProperties.getSite();
    }

    @Override
    public String cron() {
        if (log.isDebugEnabled()) {
            log.debug("{}: {}", taskName(), orderTimerConfigProperties.getPullOrderCron());
        }

        return orderTimerConfigProperties.getPullOrderCron();
    }
}
