package com.bxm.component.tbk.order.timer;

import com.bxm.component.tbk.order.config.OrderTimerConfigProperties;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.service.PullOrderService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 每日定时更新订单状态
 *
 * @author: Gonzo
 * @date 2020-05-02 10:25
 * @since 1.7.0
 */
@Component
@Slf4j
@AllArgsConstructor
public class UpdateOrderStatusTask extends AbstractCronTask<String> {

    private final PullOrderService pullOrderService;

    private final OrderTimerConfigProperties orderTimerConfigProperties;

    private final TbkOpenOrderProperties tbkOpenOrderProperties;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("执行任务: {} 开始", taskName());

        try {

            log.info("同步渠道订单状态开始");
            pullOrderService.syncChannelOrderStatus();
            log.info("同步渠道订单状态结束");

            log.info("同步常规订单状态开始");
            pullOrderService.syncGeneralOrderStatus();
            log.info("同步常规订单状态结束");

            log.info("执行任务: {} 结束", taskName());
        } catch (Exception e) {
            log.error("执行任务: {} 失败", taskName(), e);
            return ReturnT.FAIL;
        }

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "同步订单信息" + tbkOpenOrderProperties.getSite();
    }

    @Override
    public String cron() {
        if (log.isDebugEnabled()) {
            log.debug("{}: {}", taskName(), orderTimerConfigProperties.getUpdateOrderStatusCron());
        }

        return orderTimerConfigProperties.getUpdateOrderStatusCron();
    }
}
