/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.tbk.order.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.model.dto.TbkOrderInfo;
import com.bxm.component.tbk.order.model.dto.TbkOrderPageInfo;
import com.bxm.component.tbk.order.model.enums.OrderTypeEnum;
import com.bxm.component.tbk.order.model.resp.RefundResponse;
import com.bxm.newidea.component.tools.DateUtils;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.TbkOrderDetailsGetRequest;
import com.taobao.api.request.TbkRelationRefundRequest;
import com.taobao.api.response.TbkOrderDetailsGetResponse;
import com.taobao.api.response.TbkRelationRefundResponse;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TbkOrderApi {
    private static final Logger log = LoggerFactory.getLogger(TbkOrderApi.class);
    private final TbkOpenOrderProperties tbkOpenOrderProperties;
    private final TaobaoClient client;

    public TbkOrderPageInfo<TbkOrderInfo> pullOrderNew(Long pageNo, Long pageSize, String positionIndex, Date orderStartTime, Date orderEndTime, int type) {
        return this.pullOrderNew(pageNo, pageSize, positionIndex, DateUtils.formatDateTime((Date)orderStartTime), DateUtils.formatDateTime((Date)orderEndTime), type);
    }

    public TbkOrderPageInfo<TbkOrderInfo> pullOrderNew(Long pageNo, Long pageSize, String positionIndex, LocalDateTime orderStartTime, LocalDateTime orderEndTime, int type) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return this.pullOrderNew(pageNo, pageSize, positionIndex, formatter.format(orderStartTime), formatter.format(orderEndTime), type);
    }

    public TbkOrderPageInfo<TbkOrderInfo> pullOrderNew(Long pageNo, Long pageSize, String positionIndex, String orderStartTime, String orderEndTime, int type) {
        TbkOrderDetailsGetResponse rsp;
        TbkOrderPageInfo<TbkOrderInfo> tbOrderPageInfo = new TbkOrderPageInfo<TbkOrderInfo>();
        TbkOrderDetailsGetRequest req = new TbkOrderDetailsGetRequest();
        req.setQueryType(Long.valueOf(1L));
        req.setPositionIndex(positionIndex);
        req.setPageSize(pageSize);
        req.setPageNo(pageNo);
        req.setStartTime(orderStartTime);
        req.setEndTime(orderEndTime);
        req.setMemberType(Long.valueOf(2L));
        this.convertSceneType(req, type);
        try {
            rsp = (TbkOrderDetailsGetResponse)this.client.execute((TaobaoRequest)req);
        }
        catch (ApiException e) {
            log.error("\u62c9\u53d6\u8ba2\u5355\u5f02\u5e38, \u62c9\u53d6\u65f6\u95f4:{}", (Object)orderStartTime, (Object)e);
            return null;
        }
        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty((Collection)rsp.getData().getResults())) {
            log.info("\u4ece\u6dd8\u5b9d\u83b7\u53d6\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a\u6216\u8005\u5931\u8d25,\u67e5\u8be2\u65f6\u95f4\u4e3a:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)orderStartTime, JSON.toJSON((Object)rsp));
            return null;
        }
        List resultRsp = rsp.getData().getResults();
        ArrayList<TbkOrderInfo> orderInfoList = new ArrayList<TbkOrderInfo>();
        for (TbkOrderDetailsGetResponse.PublisherOrderDto publisherOrderDto : resultRsp) {
            orderInfoList.add(this.convertOrderInfoNew(publisherOrderDto, type));
        }
        TbkOrderDetailsGetResponse.OrderPage tbOrderPage = rsp.getData();
        tbOrderPageInfo.setHasNext(tbOrderPage.getHasNext());
        tbOrderPageInfo.setHasPre(tbOrderPage.getHasPre());
        tbOrderPageInfo.setPageNo(tbOrderPage.getPageNo());
        tbOrderPageInfo.setPageSize(tbOrderPage.getPageSize());
        tbOrderPageInfo.setPositionIndex(tbOrderPage.getPositionIndex());
        tbOrderPageInfo.setList(orderInfoList);
        return tbOrderPageInfo;
    }

    public List<RefundResponse> pullRefundOrder(Long pageSize, Long searchType, Long refundType, Long pageNo, Long bizType, Date startTime) {
        DefaultTaobaoClient client = new DefaultTaobaoClient(this.tbkOpenOrderProperties.getTbOpenOrderUrl(), this.tbkOpenOrderProperties.getAppKey(), this.tbkOpenOrderProperties.getAppSecret());
        TbkRelationRefundRequest req = new TbkRelationRefundRequest();
        TbkRelationRefundRequest.TopApiRefundRptOption obj1 = new TbkRelationRefundRequest.TopApiRefundRptOption();
        obj1.setPageSize(pageSize);
        obj1.setSearchType(searchType);
        obj1.setRefundType(refundType);
        obj1.setStartTime(startTime);
        obj1.setPageNo(pageNo);
        obj1.setBizType(bizType);
        req.setSearchOption(obj1);
        log.info("\u67e5\u8be2\u9000\u6b3e\u4fe1\u606f \u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)req));
        try {
            String tbkRelationRefundResponse;
            TbkRelationRefundResponse rsp = (TbkRelationRefundResponse)client.execute((TaobaoRequest)req);
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2\u9000\u6b3e\u4fe1\u606f\u8fd4\u56de: {}", (Object)JSON.toJSONString((Object)rsp));
            }
            while (!(Objects.nonNull(rsp) && rsp.isSuccess() && StringUtils.isNotBlank((CharSequence)rsp.getBody()))) {
            }
            JSONObject jsonObject = JSON.parseObject((String)rsp.getBody());
            if (Objects.nonNull(jsonObject) && StringUtils.isNotBlank((CharSequence)(tbkRelationRefundResponse = jsonObject.getString("tbk_relation_refund_response"))) && Objects.nonNull(jsonObject = JSON.parseObject((String)tbkRelationRefundResponse))) {
                String data;
                String result = jsonObject.getString("result");
                if (StringUtils.isNotBlank((CharSequence)tbkRelationRefundResponse) && Objects.nonNull(jsonObject = JSON.parseObject((String)result)) && StringUtils.isNotBlank((CharSequence)(data = jsonObject.getString("data"))) && Objects.nonNull(jsonObject = JSON.parseObject((String)data))) {
                    String finalResult;
                    String results = jsonObject.getString("results");
                    if (StringUtils.isNotBlank((CharSequence)data) && Objects.nonNull(jsonObject = JSON.parseObject((String)results)) && StringUtils.isNotBlank((CharSequence)(finalResult = jsonObject.getString("result")))) {
                        return JSON.parseArray((String)finalResult, RefundResponse.class);
                    }
                }
            }
            log.warn("\u67e5\u8be2\u9000\u6b3e\u4fe1\u606f\u5931\u8d25 \u8bf7\u6c42\u53c2\u6570: {} \u8fd4\u56de\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)req), (Object)JSON.toJSONString((Object)rsp));
            return Collections.emptyList();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9000\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c \u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)req), (Object)e);
            return Collections.emptyList();
        }
    }

    public List<RefundResponse> pullRefundOrder(Long pageSize, Long searchType, Long refundType, Long pageNo, Long bizType, LocalDateTime startTime) {
        return this.pullRefundOrder(pageSize, searchType, refundType, pageNo, bizType, Date.from(startTime.atZone(ZoneId.systemDefault()).toInstant()));
    }

    private TbkOrderInfo convertOrderInfoNew(TbkOrderDetailsGetResponse.PublisherOrderDto tbOrderInfo, int type) {
        StringBuilder httpsPre = new StringBuilder("https:");
        TbkOrderInfo orderInfo = TbkOrderInfo.builder().goodsId(Objects.toString(tbOrderInfo.getItemId(), null)).goodsName(tbOrderInfo.getItemTitle()).relationId(Objects.toString(tbOrderInfo.getRelationId(), null)).specialId(Objects.toString(tbOrderInfo.getSpecialId(), null)).orderSn(Objects.toString(tbOrderInfo.getTradeId(), null)).orderParentSn(Objects.toString(tbOrderInfo.getTradeParentId(), null)).goodsPrice(StringUtils.isBlank((CharSequence)tbOrderInfo.getItemPrice()) ? null : new BigDecimal(tbOrderInfo.getItemPrice())).goodsNum(tbOrderInfo.getItemNum()).payPrice(StringUtils.isBlank((CharSequence)tbOrderInfo.getAlipayTotalPrice()) ? new BigDecimal("0.00") : new BigDecimal(tbOrderInfo.getAlipayTotalPrice())).sourceOrderCreateTime(DateUtils.parseDateTime((String)tbOrderInfo.getTkCreateTime())).sourceOrderEarningTime(DateUtils.parseDateTime((String)tbOrderInfo.getTkEarningTime())).commission(StringUtils.isBlank((CharSequence)tbOrderInfo.getPubSharePreFee()) ? null : new BigDecimal(tbOrderInfo.getPubSharePreFee())).sourceOwnerOrderStatus(null == tbOrderInfo.getTkStatus() ? null : Integer.valueOf(tbOrderInfo.getTkStatus().intValue())).source("TB").imgUrl(httpsPre.append(tbOrderInfo.getItemImg()).toString()).pid(this.parsePid(tbOrderInfo)).adzoneId(Objects.toString(tbOrderInfo.getAdzoneId())).siteId(Objects.toString(tbOrderInfo.getSiteId())).type(type).tbOrderType(tbOrderInfo.getOrderType()).createTime(new Date()).sourceStr(JSON.toJSONString((Object)tbOrderInfo)).build();
        return orderInfo;
    }

    private String parsePid(TbkOrderDetailsGetResponse.PublisherOrderDto tbOrderInfo) {
        StringBuilder pid = new StringBuilder("mm_456760114_").append(tbOrderInfo.getSiteId()).append("_").append(tbOrderInfo.getAdzoneId());
        return pid.toString();
    }

    private void convertSceneType(TbkOrderDetailsGetRequest req, int orderType) {
        if (OrderTypeEnum.CHANNEL_ORDER.getCode() == orderType) {
            req.setOrderScene(Long.valueOf(2L));
            return;
        }
        if (OrderTypeEnum.GENERAL_ORDER.getCode() == orderType) {
            req.setOrderScene(Long.valueOf(1L));
            return;
        }
        req.setOrderScene(Long.valueOf(2L));
    }

    public TbkOrderApi(TbkOpenOrderProperties tbkOpenOrderProperties, TaobaoClient client) {
        this.tbkOpenOrderProperties = tbkOpenOrderProperties;
        this.client = client;
    }
}

