/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.tbk.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.tbk.order.api.TbkOrderApi;
import com.bxm.component.tbk.order.config.OrderTimerConfigProperties;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.model.dto.LongTimeNoCheckOrderInfo;
import com.bxm.component.tbk.order.model.dto.TbkOrderInfo;
import com.bxm.component.tbk.order.model.dto.TbkOrderPageInfo;
import com.bxm.component.tbk.order.model.enums.BusinesSiteId;
import com.bxm.component.tbk.order.model.enums.OrderTypeEnum;
import com.bxm.component.tbk.order.model.enums.TbkOrderType;
import com.bxm.component.tbk.order.service.EleTakeOutOrderService;
import com.bxm.component.tbk.order.service.PullOrderService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractPullOrderService
implements PullOrderService {
    private static final Logger log = LoggerFactory.getLogger(AbstractPullOrderService.class);
    @Autowired
    private TbkOrderApi tbkOrderApi;
    @Autowired
    private EleTakeOutOrderService eleTakeOutOrderService;
    @Autowired
    private OrderTimerConfigProperties orderTimerConfigProperties;
    @Autowired
    private TbkOpenOrderProperties tbkOpenOrderProperties;

    @Override
    public void pullOrder() {
        if (!this.orderTimerConfigProperties.getPullOrderSwitch().booleanValue()) {
            log.info("\u6bcf2\u5206\u949f\u8ba2\u5355\u62c9\u53d6\u5f00\u5173\u5173\u95ed,\u4e0d\u8fdb\u884c\u62c9\u53d6");
            return;
        }
        this.queryApiAndUpdate(LocalDateTime.now().minusMinutes(15L), LocalDateTime.now(), OrderTypeEnum.CHANNEL_ORDER);
    }

    @Override
    public void pullOrderByDay() {
        if (!this.orderTimerConfigProperties.getPullOrderDaySwitch().booleanValue()) {
            log.info("\u6bcf\u534a\u5929\u8ba2\u5355\u62c9\u53d6\u5f00\u5173\u5173\u95ed,\u4e0d\u8fdb\u884c\u62c9\u53d6");
            return;
        }
        this.queryApiAndUpdateByDays(LocalDateTime.now().minusHours(8L), LocalDateTime.now().minusHours(1L), OrderTypeEnum.CHANNEL_ORDER);
    }

    @Override
    public void pullGeneralOrder() {
        if (!this.orderTimerConfigProperties.getPullOrderSwitchGeneral().booleanValue()) {
            log.info("\u5e38\u89c4\u8ba2\u5355\u62c9\u53d6\u5f00\u5173\u5173\u95ed,\u4e0d\u8fdb\u884c\u62c9\u53d6");
            return;
        }
        this.queryApiAndUpdate(LocalDateTime.now().minusMinutes(3L), LocalDateTime.now(), OrderTypeEnum.GENERAL_ORDER);
    }

    @Override
    public void syncChannelOrderStatus() {
        if (!this.orderTimerConfigProperties.getOrderStatusSyncQuartzFlag().booleanValue()) {
            log.info("\u5b9a\u65f6\u5f00\u5173\u672a\u5f00\u542f!");
            return;
        }
        this.doSynchronizedIn30(OrderTypeEnum.CHANNEL_ORDER);
        this.doSynchronizedOver30(OrderTypeEnum.CHANNEL_ORDER);
    }

    @Override
    public void syncGeneralOrderStatus() {
        if (!this.orderTimerConfigProperties.getPullOrderSwitchGeneral().booleanValue()) {
            log.info("\u5b9a\u65f6\u5f00\u5173\u672a\u5f00\u542f!");
            return;
        }
        this.doSynchronizedIn30(OrderTypeEnum.GENERAL_ORDER);
        this.doSynchronizedOver30(OrderTypeEnum.GENERAL_ORDER);
    }

    private void queryApiAndUpdateByDays(LocalDateTime start, LocalDateTime end, OrderTypeEnum type) {
        while (start.isBefore(end)) {
            LocalDateTime localDateTime = start;
            start = start.plusHours(1L);
            this.queryApiAndUpdate(localDateTime, start, type);
        }
    }

    @Override
    public void queryApiAndUpdate(LocalDateTime start, LocalDateTime end, OrderTypeEnum type) {
        TbkOrderPageInfo<TbkOrderInfo> tbkOrderPageInfo;
        long pageNo = 1L;
        String positionIndex = null;
        do {
            log.info("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f: start :{} end: {}, pageNo: {} positionIndex: {} type: {}", new Object[]{start, end, pageNo, positionIndex, type});
            tbkOrderPageInfo = this.tbkOrderApi.pullOrderNew((Long)pageNo, (Long)100L, positionIndex, start, end, type.getCode());
            if (Objects.isNull(tbkOrderPageInfo)) break;
            if (!CollectionUtils.isEmpty(tbkOrderPageInfo.getList())) {
                tbkOrderPageInfo.getList().stream().filter(p -> Objects.equals(p.getSiteId(), this.tbkOpenOrderProperties.getBusinessSiteId())).forEach(this::handleOrderInfo);
            }
            pageNo = tbkOrderPageInfo.nextPageNo();
            positionIndex = tbkOrderPageInfo.getPositionIndex();
        } while (Objects.equals(tbkOrderPageInfo.getHasNext(), Boolean.TRUE));
    }

    private void doSynchronizedIn30(OrderTypeEnum type) {
        LocalDateTime end = LocalDateTime.now();
        LocalDateTime start = end.minusMonths(1L);
        this.queryApiAndUpdateByDays(start, end, type);
    }

    private void doSynchronizedOver30(OrderTypeEnum type) {
        List<LongTimeNoCheckOrderInfo> longTimeNoCheckOrders = this.getLongTimeNoCheckOrders(type);
        longTimeNoCheckOrders.forEach(p -> {
            log.info("\u5904\u7406\u5386\u53f2\u8ba2\u5355: {} \u521b\u5efa\u65f6\u95f4: {}", (Object)p.getOrderSn(), (Object)p.getSourceOrderCreateTime());
            if (Objects.nonNull(p.getSourceOrderCreateTime())) {
                LocalDateTime end = p.getSourceOrderCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                this.queryApiAndUpdateByDays(end.minusMinutes(2L), end.plusMinutes(2L), type);
            }
        });
    }

    private Boolean handleOrderInfo(TbkOrderInfo orderInfo) {
        if (Objects.isNull(orderInfo)) {
            log.warn("\u8d2d\u7269\u8ba2\u5355\u6570\u636e\u4e3anull \u65e0\u6cd5\u5904\u7406");
            return false;
        }
        if (Objects.equals(orderInfo.getTbOrderType(), TbkOrderType.ELE.getType())) {
            return this.eleTakeOutOrderService.syncOrder(orderInfo);
        }
        return this.handleCommodityOrderInfo(orderInfo);
    }

    public boolean handleCommodityOrderInfo(TbkOrderInfo orderInfo) {
        try {
            BusinesSiteId siteId = BusinesSiteId.getById(orderInfo.getSiteId());
            log.info("\u5904\u7406\u8d2d\u7269\u8ba2\u5355{}, \u63a8\u5e7f\u4f4did: {} \u6765\u6e90: {} \u8ba2\u5355\u6570\u636e: {}", new Object[]{orderInfo.getOrderSn(), orderInfo.getSiteId(), Objects.isNull((Object)siteId) ? "\u672a\u5b9a\u4e49" : siteId.getDes(), JSON.toJSONString((Object)orderInfo)});
            return this.doHandleCommodityOrderInfo(orderInfo);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u8d2d\u7269\u8ba2\u5355\u5931\u8d25 \u8ba2\u5355\u6570\u636e: {}", (Object)JSON.toJSONString((Object)orderInfo), (Object)e);
            return false;
        }
    }

    protected abstract List<LongTimeNoCheckOrderInfo> getLongTimeNoCheckOrders(OrderTypeEnum var1);

    protected abstract boolean doHandleCommodityOrderInfo(TbkOrderInfo var1);
}

