package com.bxm.component.tbk.order.config;

import com.bxm.component.tbk.order.model.enums.BusinesSiteId;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 淘宝开发平台订单相关的配置信息
 * @Author: Gonzo
 * @date  2020-04-22 17:09
 * @since 1.7.0
 */
@Component
@ConfigurationProperties("order.config.tb-open.order")
@Data
public class TbkOpenOrderProperties {

    /**
     * 淘宝开放平台订单的请求地址
     * 正式环境 http://gw.api.taobao.com/router/rest
     *  带https https://eco.taobao.com/router/rest
     * 沙箱环境 http://gw.api.tbsandbox.com/router/rest
     *  带https https://gw.api.tbsandbox.com/router/rest
     */
    private String tbOpenOrderUrl = "https://eco.taobao.com/router/rest";

    /**
     * appKey
     */
    private String appKey = "27650304";

    /**
     * appSecret
     */
    private String appSecret = "a28530f72a39d0270762d98ba1f2273b";

    /**
     * 查询数据时的页面大小
     * 默认10
     */
    private Long queryPageSize = 10L;

    /**
     * 业务主体
     */
    private String site = Objects.toString(BusinesSiteId.FOSSICKER);

    /**
     * 推广位id
     * 默认趣淘金id
     * @see BusinesSiteId
     */
    private String businessSiteId = BusinesSiteId.FOSSICKER.getId();
}
