package com.bxm.component.tbk.order.service;

import com.bxm.component.tbk.order.model.dto.MeituanOrderSourceInfo;

import java.time.LocalDateTime;

/**
 * 美团外卖订单处理
 * @author Gonzo
 * @date  2020-05-03 17:16
 * @since 2.0.0
 */
public interface MeituanTakeOutOrderService {
    /**
     * 美团订单推送
     * @param orderInfo 订单信息
     * @return 1 表示 推送成功，并且订单已成功入库。0 表示 推送成功，但订单已存在。-1 表示 推送失败。
     */
    Integer orderNotice(MeituanOrderSourceInfo orderInfo);

    /**
     * 同步前几日订单数据
     * 避免订单推送跟踪丢掉，每天一次的弥补操作
     */
    void syncOrderOneDayOnce();

    /**
     * 根据时间同步订单
     * @param timeFrom 订单创建开始时间
     * @param timeTo 订单创建结束时间
     * @param chargeFrom 订单结算开始时间
     * @param chargeTo 订单结算结束时间
     */
    void syncOrder(LocalDateTime timeFrom, LocalDateTime timeTo,
                   LocalDateTime chargeFrom, LocalDateTime chargeTo);
}
