package com.bxm.component.tbk.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.tbk.order.api.TbkOrderApi;
import com.bxm.component.tbk.order.config.TbkOpenOrderProperties;
import com.bxm.component.tbk.order.model.resp.RefundResponse;
import com.bxm.component.tbk.order.service.OrderRefundService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 维权订单处理
 * @author Gonzo
 * @date  2020-05-03 16:59
 * @since 2.0.0
 */
@Slf4j
public abstract class AbstractOrderRefundService implements OrderRefundService {

    @Autowired
    private TbkOrderApi tbOrderService;

    @Autowired
    private TbkOpenOrderProperties tbOpenOrderProperties;

    @Override
    public void pullRefundOrderDays() {
        // 入参：【维权完成时间】【前一日10:30-今日10:30】【2方】【1渠道关系ID】
        LocalDateTime startDateTime = LocalDateTime.now();
        // 前一日
        pullRefundOrder(startDateTime.minusDays(1L));
    }

    @Override
    public void  pullRefundOrder(LocalDateTime startDateTime) {
        log.info("拉取维权订单 开始 startDateTime: {}", startDateTime);
        try {
            LocalDateTime now = LocalDateTime.now();

            while (now.isAfter(startDateTime)) {
                long i = 0;
                while (true) {
                    log.info("拉取维权订单 本次查询时间: {} 页数: {}", startDateTime, i);
                    List<RefundResponse> results =  tbOrderService.pullRefundOrder(
                            tbOpenOrderProperties.getQueryPageSize(), 1L, 1L,
                            ++i, 1L, startDateTime);

                    if (CollectionUtils.isEmpty(results)) {
                        break;
                    }
                    results.forEach(this::handleRefundOrder);
                }

                startDateTime = startDateTime.plusDays(1);
            }

        } catch(Exception e) {
            log.error("拉取维权订单出现错误 : {}", startDateTime, e);
        }
    }

    /**
     * 处理退款订单信息
     * @param response 退款订单信息
     */
    private void handleRefundOrder(RefundResponse response) {
        try {
            log.info("处理退款订单信息: {}", response.getTbTradeId());

            doHandleRefundOrder(response);
        } catch(Exception e) {
            log.error("处理退款订单失败，订单信息: {}", JSON.toJSONString(response), e);
        }
    }

    /**
     * 处理退款订单信息
     * @param response
     */
    protected abstract void doHandleRefundOrder(RefundResponse response);
}
