package com.bxm.component.tbk.order.model.param;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

@Data
public class QueryMeituanOrderListParam {

    /**
     * 	string
     * 	是
     * 	355d9878e6469953b0383452533b6f43
     * 	接口密钥, 查看如何获取媒体接口密钥
     */
    private String hash;

    /**
     * string
     * 是
     * query
     * 请求动作，订单查询请填 action=query
     */
    private String action = "query";

    /**
     * 	number
     * 	否
     * 	1234
     * 	媒体ID
     */
    @JSONField(name = "site_id")
    private String siteId;

    /**
     * 	number
     * 	否
     * 	4155
     * 	推广计划ID
     */
    @JSONField(name = "ads_id")
    private String adsId;

    /**
     * 	string
     * 	否
     * 	1234
     * 	订单反馈标签值 查看反馈标签说明
     */
    private String euid;

    /**
     * 	string
     * 	否
     * 	2019-04-05 12:18:22
     * 	订单生成（下单）开始时间，格式 例如 2012-05-12 12:18:22 支持到秒
     */
    @JSONField(name = "time_from")
    private String timeFrom;

    /**
     * 	string
     * 	否
     * 	2019-04-23 12:28:22
     * 	订单生成（下单）结束时间 格式同上
     */
    @JSONField(name = "time_to")
    private String timeTo;

    /**
     * 	string
     * 	否
     * 	2019-04-23 12:28:22
     * 	订单结算开始时间 格式同上
     */
    @JSONField(name = "charge_from")
    private String chargeFrom;

    /**
     * 	string
     * 	否
     * 	2019-04-23 12:28:22
     * 	订单结算结束时间 格式同上
     */
    @JSONField(name = "charge_to")
    private String chargeTo;

    /**
     * 	string
     * 	否
     * 	0
     * 	查询特定状态的订单 可选值： -1 无效 0 未确认 1 确认 2 结算查看订单状态说明
     */
    private String status;

    /**
     * 	string
     * 	否
     * 	0,100
     * 	获取的结果集数量，格式为：开始值，条数 。例如 0,100 表示结果集按照订单时间排序后 取偏移0 开始的 100条数据。不传递 则获取全部满足条件的订单
     */
    private String limit;

    /**
     * 	string
     * 	否
     * 	time,desc
     * 	结果排序，格式为：[time/id],[desc/asc] 大小写不限制，例如 order=time,desc 按下单时间倒排。不填则默认为id 降序 排序， time 按订单下单时间排序。desc 为降序， asc 为升序
     */
    private String order;

    /**
     * string
     * 否
     * xml
     * 默认返回XML 格式的数据，如需获取 json 格式请填 format=json
     */
    private String format;

}
