/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.tbk.factory;

import com.bxm.component.tbk.config.TbkConfigProperties;
import com.bxm.newidea.component.enums.AppNameEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaobaoClientFactory {
    private static final Logger log = LoggerFactory.getLogger(TaobaoClientFactory.class);
    private static final Map<String, TaobaoClient> TAOBAO_CLIENT_MAP = Maps.newHashMap();
    private static final List<TbkSiteConfig> DEFAULT_CONFIG = Lists.newArrayList();
    private static final String TB_OPEN_URL = "https://eco.taobao.com/router/rest";

    public TaobaoClientFactory(TbkConfigProperties properties) {
        if (Objects.isNull(properties.getTbkAppKeyConfigMap()) || properties.getTbkAppKeyConfigMap().isEmpty() || Objects.isNull(properties.getTbkAppSecretConfigMap()) || properties.getTbkAppSecretConfigMap().isEmpty()) {
            DEFAULT_CONFIG.forEach(p -> {
                String url = TB_OPEN_URL;
                String siteId = p.getSiteId();
                String appKey = p.getAppKey();
                String appSecret = p.getAppSecret();
                log.info("\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\u521d\u59cb\u5316TaoBaoClient siteId: {} url: {}, appKey: {} appSecret: {}", new Object[]{siteId, url, appKey, appSecret});
                TAOBAO_CLIENT_MAP.put(siteId, (TaobaoClient)new DefaultTaobaoClient(url, appKey, appSecret));
            });
            return;
        }
        properties.getTbkAppKeyConfigMap().forEach((key, value) -> {
            String url = properties.getTbOpenUrl();
            String siteId = key;
            String appKey = value;
            String appSecret = properties.getTbkAppSecretConfigMap().get(key);
            log.info("\u521d\u59cb\u5316TaoBaoClient siteId: {}, url: {}, appKey: {} appSecret: {}", new Object[]{siteId, url, appKey, appSecret});
            TAOBAO_CLIENT_MAP.put(siteId, (TaobaoClient)new DefaultTaobaoClient(url, appKey, appSecret));
        });
    }

    public TaobaoClient getClient(String appName) {
        if (log.isDebugEnabled()) {
            log.debug("\u6839\u636eappName: {}  \u83b7\u53d6\u5b9e\u4f8b", (Object)appName);
        }
        return TAOBAO_CLIENT_MAP.get(appName);
    }

    static {
        DEFAULT_CONFIG.add(new TbkSiteConfig(AppNameEnum.FOSSICKER.name(), "27666243", "fcb41e6d06d5cea3d5e080c5e682d215"));
        DEFAULT_CONFIG.add(new TbkSiteConfig(AppNameEnum.LOCAL_NEWS.name(), "27650304", "a28530f72a39d0270762d98ba1f2273b"));
    }

    static class TbkSiteConfig {
        private String siteId;
        private String appKey;
        private String appSecret;

        public TbkSiteConfig(String siteId, String appKey, String appSecret) {
            this.siteId = siteId;
            this.appKey = appKey;
            this.appSecret = appSecret;
        }

        public String getSiteId() {
            return this.siteId;
        }

        public String getAppKey() {
            return this.appKey;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        public void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        public void setAppKey(String appKey) {
            this.appKey = appKey;
        }

        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TbkSiteConfig)) {
                return false;
            }
            TbkSiteConfig other = (TbkSiteConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$siteId = this.getSiteId();
            String other$siteId = other.getSiteId();
            if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
                return false;
            }
            String this$appKey = this.getAppKey();
            String other$appKey = other.getAppKey();
            if (this$appKey == null ? other$appKey != null : !this$appKey.equals(other$appKey)) {
                return false;
            }
            String this$appSecret = this.getAppSecret();
            String other$appSecret = other.getAppSecret();
            return !(this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TbkSiteConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $siteId = this.getSiteId();
            result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
            String $appKey = this.getAppKey();
            result = result * 59 + ($appKey == null ? 43 : $appKey.hashCode());
            String $appSecret = this.getAppSecret();
            result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
            return result;
        }

        public String toString() {
            return "TaobaoClientFactory.TbkSiteConfig(siteId=" + this.getSiteId() + ", appKey=" + this.getAppKey() + ", appSecret=" + this.getAppSecret() + ")";
        }
    }
}

