/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.component.test.config;

import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class JUnitTestSpringApplicationRunListener
implements SpringApplicationRunListener {
    private final SpringApplication application;
    private final String[] args;
    private final SimpleApplicationEventMulticaster initialMulticaster;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public JUnitTestSpringApplicationRunListener(SpringApplication application, String[] args) {
        this.application = application;
        this.args = args;
        this.initialMulticaster = new SimpleApplicationEventMulticaster();
        for (ApplicationListener listener : application.getListeners()) {
            this.initialMulticaster.addApplicationListener(listener);
        }
    }

    public void starting() {
        String env = System.getProperty("env");
        System.out.println(StringUtils.join((Object[])new String[]{"\u52a0\u8f7d\u73af\u5883\u53d8\u91cfenv: ", env}));
        if (StringUtils.isBlank((CharSequence)env)) {
            System.setProperty("env", "LOCAL");
            System.out.println("\u73af\u5883\u53d8\u91cfenv\u4e0d\u5b58\u5728\uff0c\u8bbe\u7f6e\u4e3aLOCAL\uff0c\u5355\u5143\u6d4b\u8bd5\u73af\u5883\u3002");
        }
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        String env = System.getProperty("env");
        if (StringUtils.isBlank((CharSequence)env) || Objects.equals(env, "LOCAL")) {
            this.logger.info("\u914d\u7f6e\u5355\u5143\u6d4b\u8bd5\u73af\u5883\uff0c\u7981\u7528 eureka \u7b49\u7ec4\u4ef6");
            MutablePropertySources propertySources = environment.getPropertySources();
            Properties p = new Properties();
            p.put("spring.freemarker.check-template-location", "false");
            p.put("eureka.client.enabled", "false");
            propertySources.addFirst((PropertySource)new PropertiesPropertySource("junitProperties", p));
        }
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void started(ConfigurableApplicationContext context) {
    }

    public void running(ConfigurableApplicationContext context) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }
}

