/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.thunlp.thulac.util.BufferUtils;
import org.thunlp.thulac.util.StringUtils;

public class Dat {
    public int[] dat;
    public int datSize;

    protected Dat(int size) {
        this.dat = new int[size << 1];
        this.datSize = size;
    }

    public Dat(String filename) throws IOException {
        SeekableByteChannel channel = Files.newByteChannel(Paths.get(filename, new String[0]), new OpenOption[0]);
        this.datSize = (int)(channel.size() >> 3);
        this.dat = new int[this.datSize << 1];
        ByteBuffer bb = ByteBuffer.allocateDirect(65536).order(ByteOrder.LITTLE_ENDIAN);
        bb.clear();
        if (!BufferUtils.readInts(channel, bb, new int[][]{this.dat})) {
            throw new IOException("File does not contain enough data!");
        }
        channel.close();
    }

    private int match(String word) {
        int[] codePoints;
        int ind = 0;
        int base = 0;
        for (int c : codePoints = StringUtils.toCodePoints(word)) {
            if ((ind = this.dat[ind << 1] + c) >= this.datSize || this.dat[(ind << 1) + 1] != base) {
                return -1;
            }
            base = ind;
        }
        ind = this.dat[base << 1];
        return ind < this.datSize && this.dat[(ind << 1) + 1] == base ? ind : -1;
    }

    public int getInfo(String prefix) {
        int ind = 0;
        int base = 0;
        for (int i = 0; i < prefix.length(); ++i) {
            if ((ind = this.dat[ind << 1] + prefix.charAt(i)) >= this.datSize || this.dat[(ind << 1) + 1] != base) {
                return i;
            }
            base = ind;
        }
        return -base;
    }

    public boolean containsPrefix(String prefix) {
        return this.getInfo(prefix) < 0;
    }

    public boolean contains(String word) {
        return this.match(word) != -1;
    }
}

