/*
 * Decompiled with CFR 0.152.
 */
package org.thunlp.thulac.data;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.thunlp.thulac.data.Dat;

public class DatMaker
extends Dat {
    private static Comparator<Record> RECORDS_COMPARATOR = new Comparator<Record>(){

        @Override
        public int compare(Record a, Record b) {
            return a.word.compareTo(b.word);
        }
    };
    private int head;
    private int tail;

    public static Dat readFromInputStream(InputStream in) throws IOException {
        String str;
        ArrayList<String> words = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((str = reader.readLine()) != null) {
            words.add(str);
        }
        reader.close();
        DatMaker dat = new DatMaker();
        dat.buildDat(words);
        return dat;
    }

    public static Dat readFromTxtFile(String filename) throws IOException {
        return DatMaker.readFromInputStream(new FileInputStream(filename));
    }

    private DatMaker() {
        super(1);
        this.dat[1] = -1;
        this.dat[0] = -1;
        this.tail = 0;
        this.head = 0;
    }

    private void markAsUsed(int index) {
        int base = this.dat[index << 1];
        int check = this.dat[(index << 1) + 1];
        if (check >= 0) {
            throw new RuntimeException("Cell reused! Index: " + index);
        }
        if (base == -1) {
            this.head = check;
        } else {
            this.dat[(-base << 1) + 1] = check;
        }
        if (check == -this.datSize) {
            this.tail = base;
        } else {
            this.dat[-check << 1] = base;
        }
        this.dat[(index << 1) + 1] = index;
    }

    private void expandDat() {
        int oldSize = this.datSize;
        this.datSize *= 2;
        int[] newDat = new int[this.dat.length << 1];
        System.arraycopy(this.dat, 0, newDat, 0, this.dat.length);
        this.dat = newDat;
        for (int i = 0; i < oldSize; ++i) {
            int pos = oldSize + i << 1;
            newDat[pos] = -(oldSize + i - 1);
            newDat[pos + 1] = -(oldSize + i + 1);
        }
        this.dat[oldSize << 1] = this.tail;
        this.dat[(-this.tail << 1) + 1] = -oldSize;
        this.tail = -(oldSize * 2 - 1);
    }

    private void packDat() {
        int last = this.datSize - 1;
        while (this.dat[(last << 1) + 1] < 0) {
            --last;
        }
        this.datSize = last + 1;
        int[] newDat = new int[this.datSize << 1];
        System.arraycopy(this.dat, 0, newDat, 0, this.datSize << 1);
        this.dat = newDat;
    }

    private int allocate(List<Integer> offsets) {
        int size = offsets.size();
        int base = -this.head;
        while (true) {
            if (base == this.datSize) {
                this.expandDat();
            }
            if (size != 0) {
                int requiredSize = base + offsets.get(size - 1);
                while (requiredSize >= this.datSize) {
                    this.expandDat();
                }
            }
            boolean available = true;
            if (this.dat[(base << 1) + 1] >= 0) {
                available = false;
            } else {
                int i;
                for (i = 0; i < size && this.dat[(base + offsets.get(i) << 1) + 1] < 0; ++i) {
                }
                if (i < size) {
                    available = false;
                }
            }
            if (available) {
                this.markAsUsed(base);
                for (int offset : offsets) {
                    this.markAsUsed(base + offset);
                }
                return base;
            }
            int newBase = -this.dat[(base << 1) + 1];
            if (newBase == this.datSize) {
                this.expandDat();
            }
            base = newBase;
        }
    }

    private List<Integer> findChildren(List<Record> lexicon, int start, String prefix) {
        ArrayList<Integer> children = new ArrayList<Integer>();
        int length = prefix.length();
        int n = -1;
        int size = lexicon.size();
        for (int i = start; i < size; ++i) {
            char c;
            char nextCh;
            String word = lexicon.get((int)i).word;
            if (!word.startsWith(prefix)) {
                return children;
            }
            if (word.length() == length || (nextCh = word.charAt(length)) == c) continue;
            c = nextCh;
            children.add(Integer.valueOf(c));
        }
        return children;
    }

    private int populate(int check, List<Integer> offsets, boolean isWord) {
        int base = this.allocate(offsets);
        this.dat[base << 1] = 0;
        this.dat[(base << 1) + 1] = isWord ? check : base;
        for (int offset : offsets) {
            int pos = base + offset << 1;
            this.dat[pos] = 0;
            this.dat[pos + 1] = check;
        }
        this.dat[check << 1] = base;
        return base;
    }

    private void buildDat(List<String> words) {
        int i;
        Vector<Record> lexicon = new Vector<Record>();
        lexicon.add(new Record());
        int size = words.size();
        for (i = 0; i < size; ++i) {
            lexicon.add(new Record(words.get(i), i));
        }
        lexicon.sort(RECORDS_COMPARATOR);
        this.dat[0] = this.populate(0, this.findChildren(lexicon, 0, ""), true);
        size = lexicon.size();
        for (i = 0; i < size; ++i) {
            String word = lexicon.get((int)i).word;
            int off = this.getInfo(word);
            if (off <= 0) {
                off = word.length();
            }
            for (int offset = off; offset <= word.length(); ++offset) {
                String prefix = word.substring(0, offset);
                int pBase = -this.getInfo(prefix);
                this.populate(pBase, this.findChildren(lexicon, i, prefix), offset == word.length());
            }
            off = -this.getInfo(word);
            this.dat[this.dat[off << 1] << 1] = lexicon.get((int)i).num;
        }
        this.packDat();
    }

    private static class Record {
        public String word;
        public int num;

        public Record() {
            this("", 0);
        }

        public Record(String key, int value) {
            this.word = key;
            this.num = value;
        }
    }
}

