package com.bxm.newidea.component.uuid.config;

import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.impl.SnowflakeSequenceCreater;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * uuid模块的相关配置
 * @author liujia
 * @date 2020/04/23 09:35
 */
@Configuration
@EnableConfigurationProperties(ComponentUUIDConfigurationProperties.class)
public class ComponentUUIDAutoConfiguration {

    private ComponentUUIDConfigurationProperties properties;

    public ComponentUUIDAutoConfiguration(ComponentUUIDConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(SequenceCreater.class)
    public SequenceCreater sequenceCreater() {
        SnowflakeSequenceCreater creator = new SnowflakeSequenceCreater();
        creator.init(properties);
        return creator;
    }
}
