package com.bxm.newidea.component.uuid.config;

import com.bxm.newidea.component.strategy.ReturnedStrategyExecutor;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.snowflake.SnowflakeSequenceCrater;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * uuid模块的相关配置
 *
 * @author liujia
 * @date 2020/04/23 09:35
 */
@Configuration
@EnableConfigurationProperties(ComponentUUIDConfigurationProperties.class)
public class ComponentUUIDAutoConfiguration implements ApplicationRunner {

    private ComponentUUIDConfigurationProperties properties;

    private ReturnedStrategyExecutor returnedStrategyExecutor;

    public ComponentUUIDAutoConfiguration(ComponentUUIDConfigurationProperties properties,
                                          ReturnedStrategyExecutor returnedStrategyExecutor) {
        this.properties = properties;
        this.returnedStrategyExecutor = returnedStrategyExecutor;
    }

    @Bean
    @ConditionalOnMissingBean(SequenceCreater.class)
    public SequenceCreater sequenceCreater() {
        return new SnowflakeSequenceCrater(properties, returnedStrategyExecutor);
    }

    @Override
    public void run(ApplicationArguments args) {
        SequenceHolder.sequenceCreater = SpringContextHolder.getBean(SequenceCreater.class);
    }
}
