/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.uuid;

import com.bxm.newidea.component.uuid.SystemClock;

public class Sequence {
    private final long startTime = 1519740777809L;
    private final long workerIdBits = 2L;
    private final long dataCenterIdBits = 5L;
    private final long sequenceBits = 4L;
    private final long maxWorkerId = 3L;
    private final long maxDataCenterId = 31L;
    private final long workerIdShift = 4L;
    private final long dataCenterIdShift = 6L;
    private final long timestampLeftShift = 11L;
    private final long sequenceMask = 15L;
    private long workerId;
    private long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private boolean isClock = false;

    public Sequence(long workerId, long dataCenterId) {
        if (workerId > 3L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 3L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("dataCenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public void setClock(boolean clock) {
        this.isClock = clock;
    }

    public synchronized Long nextId() {
        long timestamp;
        block8: {
            timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - timestamp;
                if (offset <= 5L) {
                    try {
                        this.wait(offset << 1);
                        timestamp = this.timeGen();
                        if (timestamp < this.lastTimestamp) {
                            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1519740777809L << 11 | this.dataCenterId << 6 | this.workerId << 4 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        if (this.isClock) {
            return SystemClock.now();
        }
        return System.currentTimeMillis();
    }
}

