package com.bxm.newidea.component.constraints;

import com.bxm.newidea.component.constraintvalidators.MobilePhoneNumberValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * @author liujia
 * @date 2020/04/22 10:23
 */
@Documented
@Constraint(validatedBy = MobilePhoneNumberValidator.class)
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER, TYPE_USE})
@Retention(RUNTIME)
public @interface MobilePhoneNumber {

    String message() default "手机号码格式错误";

    Class<?>[] groups() default {};

    /**
     * 是否使用严格模式，默认不启用
     */
    boolean strict() default false;

    Class<? extends Payload>[] payload() default {};
}