/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.mvc;

import com.bxm.newidea.component.exceptions.BusinessException;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import com.google.common.base.Joiner;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
@ResponseBody
public class CustomizeExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomizeExceptionHandler.class);

    @ExceptionHandler(value={BusinessException.class})
    public ResponseJson handleBusinessException(BusinessException e, HttpServletRequest request) {
        this.log(request, e);
        return ResponseJson.badReqeuset(e.getMessage()).build();
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseJson handleBusinessException(IllegalArgumentException e, HttpServletRequest request) {
        this.log(request, e);
        return ResponseJson.badReqeuset("\u8bf7\u6c42\u53c2\u6570\u4e0d\u7b26\u5408API\u8981\u6c42").build();
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class, ValidationException.class})
    public ResponseJson handleValidException(Exception e, HttpServletRequest request) {
        String errorMsg = null;
        if (e instanceof ConstraintViolationException) {
            ConstraintViolationException violationException = (ConstraintViolationException)e;
            if (violationException.getConstraintViolations() != null) {
                List errorMsgList = violationException.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
                errorMsg = Joiner.on((String)";").skipNulls().join(errorMsgList);
            }
        } else if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException validException = (MethodArgumentNotValidException)e;
            BindingResult bindingResult = validException.getBindingResult();
            List fieldErrors = bindingResult.getFieldErrors();
            List errorMsgList = fieldErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
            errorMsg = Joiner.on((String)";").skipNulls().join(errorMsgList);
        }
        log.warn("uri:[{}],param:[{}]", (Object)request.getRequestURI(), (Object)WebUtils.getReqeustParam(request));
        log.warn(e.getMessage(), (Throwable)e);
        if (null == errorMsg) {
            errorMsg = e.getMessage();
        }
        return ResponseJson.badReqeuset(errorMsg).build();
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseJson handleBusinessException(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        this.log(request, (Exception)e);
        return ResponseJson.badReqeuset("\u8bf7\u9009\u62e9\u4e0eAPI\u4e00\u81f4\u7684RequestMethod").build();
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseJson handleException(Exception e, HttpServletRequest request) {
        this.log(request, e);
        return ResponseJson.serverError("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5").build();
    }

    private void log(HttpServletRequest request, Exception e) {
        log.error("uri:[{}],param:[{}]", (Object)request.getRequestURI(), (Object)WebUtils.getReqeustParam(request));
        log.error(e.getMessage(), (Throwable)e);
    }
}

