/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.log;

import com.bxm.newidea.component.util.WebUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@WebFilter(filterName="log4j2ContextFilter", urlPatterns={"/**"})
public class LogContextFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LogContextFilter.class);

    public void init(FilterConfig filterConfig) {
        if (log.isDebugEnabled()) {
            log.debug("init log context filter");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (log.isDebugEnabled()) {
            String url = request.getRequestURI();
            String requestParam = WebUtils.getRequestParam(request);
            log.debug("\u8bf7\u6c42\u5730\u5740\uff1a[{}]\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}]", (Object)url, (Object)requestParam);
        }
        ThreadContext.put((String)"requestIp", (String)WebUtils.getIpAddr(request));
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        ThreadContext.clearAll();
    }
}

