/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebUtils {
    private static Logger logger = LoggerFactory.getLogger(WebUtils.class);

    private WebUtils() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            ipAddress = WebUtils.getLocalRealIp();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String getLocalRealIp() {
        String localip = null;
        String netip = null;
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            boolean finded = false;
            block2: while (netInterfaces.hasMoreElements() && !finded) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    if (!(ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":"))) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block2;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                    localip = ip.getHostAddress();
                }
            }
            if (netip != null && !"".equals(netip)) {
                return netip;
            }
            return localip;
        }
        catch (SocketException e) {
            logger.warn("\u89e3\u6790\u672c\u673aIP\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return "127.0.0.1";
        }
    }

    public static boolean isAjax(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
    }

    public static String joinRequestParam(HttpServletRequest request, String joinChar, String ... exludeFields) {
        TreeMap paramMap = Maps.newTreeMap();
        Enumeration paramNames = request.getParameterNames();
        try {
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                if (ArrayUtils.contains((Object[])exludeFields, (Object)paramName)) continue;
                String data = request.getParameter(paramName);
                data = data.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
                data = data.replaceAll("\\+", "%2B");
                paramMap.put(paramName, URLDecoder.decode(data, StandardCharsets.UTF_8.name()));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ArrayList keyValues = Lists.newArrayList();
        paramMap.forEach((key, value) -> keyValues.add(key + "=" + value));
        return Joiner.on((String)joinChar).skipNulls().join((Iterable)keyValues);
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            return servletRequestAttributes.getRequest();
        }
        return null;
    }

    public static String getRequestParam(HttpServletRequest request) {
        if (WebUtils.isMultipartRequest(request)) {
            return "";
        }
        try {
            String param = WebUtils.joinRequestParam(request, ",", new String[0]);
            ServletInputStream body = request.getInputStream();
            if (null != body) {
                param = param + "| body content: [" + WebUtils.getRequestBodyContent(request) + "]";
            }
            return param;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static boolean isMultipartRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    public static String getRequestBodyContent(HttpServletRequest request) {
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                return "[\u6587\u4ef6\u5185\u5bb9]";
            }
            ServletInputStream body = request.getInputStream();
            if (null != body) {
                return IOUtils.toString((InputStream)body, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }
}

