package com.bxm.newidea.component.handler;

import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * 全局异常处理
 * @author liujia 2018/3/30 21:20
 */
@ControllerAdvice
@ResponseBody
public class GlobalExceptionHandler {

    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    /**
     * 处理全局异常，当具体的异常类型未匹配时
     */
    @ExceptionHandler(Exception.class)
    public ResultModel handlException(Exception e, HttpServletRequest request) {
        logError(request);
        logger.error(e.getMessage(), e);
        return ResultModel.serverError().setErrorMsg("服务器内部错误");
    }

    private void logError(HttpServletRequest request) {
        String requestParam = WebUtils.joinRequestParam(request, "|");
        logger.error("request uri:[{}],request param:[{}]", request.getRequestURI(), requestParam);
    }

}
