/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.config;

import com.bxm.component.graceful.shutdown.event.ShutdownEvent;
import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.handler.BeanByNameHandler;
import com.bxm.newidea.component.schedule.register.ScheduleRegisterService;
import com.bxm.newidea.component.schedule.register.impl.DefaultScheduleRegisterService;
import com.bxm.newidea.component.schedule.register.impl.ScheduleRegisterServiceImpl;
import com.bxm.newidea.component.schedule.service.ScheduleService;
import com.bxm.newidea.component.schedule.service.impl.ScheduleServiceImpl;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.tools.NetworkInterfaceManager;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={XxlJobConfigurationProperties.class})
@ConditionalOnMissingClass(value={"org.springframework.test.context.junit4.SpringRunner"})
public class XxlJobConfiguration
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(XxlJobConfiguration.class);
    private static final String EXECUTOR_IP = "executorIp";
    private final XxlJobConfigurationProperties properties;
    private ApplicationContext applicationContext;

    public XxlJobConfiguration(XxlJobConfigurationProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }

    @Bean
    public ScheduleRegisterService feignService() {
        if (this.properties.isMock()) {
            log.info("\u4f7f\u7528\u9ed8\u8ba4\u5b9e\u73b0\u7684ScheduleFeignService");
            return new DefaultScheduleRegisterService();
        }
        log.info("\u4f7f\u7528http\u5b9e\u73b0\u7684ScheduleFeignService");
        return new ScheduleRegisterServiceImpl(this.properties);
    }

    @Bean
    public ScheduleService scheduleService(ScheduleRegisterService registerService) {
        return new ScheduleServiceImpl(registerService, this.properties);
    }

    @Bean
    public BeanByNameHandler beanByNameHandler() {
        return new BeanByNameHandler();
    }

    @Bean(initMethod="start", destroyMethod="destroy")
    @ConditionalOnProperty(prefix="xxl.job", name={"adminAddresses"})
    public XxlJobSpringExecutor xxlJobExecutor() {
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        if (StringUtils.isBlank((String)this.properties.getAppName())) {
            throw new IllegalArgumentException("\u4f7f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u5fc5\u987b\u63d0\u4f9bxxl.job.executor.app-name\u914d\u7f6e\u5c5e\u6027");
        }
        String ip = this.properties.getIp();
        if (StringUtils.isBlank((String)ip)) {
            ip = System.getProperty(EXECUTOR_IP);
            if (StringUtils.isBlank((String)ip) && null == (ip = NetworkInterfaceManager.INSTANCE.getLocalHostAddress())) {
                throw new IllegalArgumentException("\u4f7f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u5fc5\u987b\u63d0\u4f9bxxl.job.executor.ip\u914d\u7f6e\u5c5e\u6027");
            }
            xxlJobSpringExecutor.setIp(ip);
        }
        if (StringUtils.isBlank((String)this.properties.getAdminAddresses())) {
            throw new IllegalArgumentException("\u4f7f\u7528\u8c03\u5ea6\u670d\u52a1\uff0c\u5fc5\u987b\u63d0\u4f9bxxl.job.executor.admin-address\u914d\u7f6e\u5c5e\u6027");
        }
        if (XxlJobConfigurationProperties.DEFAULT_PORT == this.properties.getPort()) {
            log.info("\u8c03\u5ea6\u670d\u52a1\u56de\u8c03\u63a5\u53e3\u4f7f\u7528\u4e86\u9ed8\u8ba4\u7684[{}]\u7aef\u53e3\uff0c\u8bf7\u6ce8\u610f\u90e8\u7f72\u65f6\u7684\u7aef\u53e3\u51b2\u7a81\u95ee\u9898", (Object)this.properties.getPort());
        }
        xxlJobSpringExecutor.setAdminAddresses(this.properties.getAdminAddresses());
        xxlJobSpringExecutor.setAppname(this.properties.getAppName());
        xxlJobSpringExecutor.setPort(this.properties.getPort());
        xxlJobSpringExecutor.setAccessToken(this.properties.getAccessToken());
        xxlJobSpringExecutor.setLogPath(this.properties.getLogPath());
        xxlJobSpringExecutor.setLogRetentionDays(this.properties.getLogRetentionDays());
        return xxlJobSpringExecutor;
    }

    @Order(value=-2147483648)
    @EventListener(value={ShutdownEvent.class})
    public void onApplicationEvent(ShutdownEvent event) {
        XxlJobSpringExecutor xxlJobSpringExecutor = (XxlJobSpringExecutor)event.getApplicationContext().getBean(XxlJobSpringExecutor.class);
        xxlJobSpringExecutor.destroy();
    }

    public void run(ApplicationArguments args) {
        ScheduleService scheduleService = (ScheduleService)this.applicationContext.getBean(ScheduleService.class);
        Map taskMap = this.applicationContext.getBeansOfType(ScheduleTask.class);
        log.info("\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1\uff0c\u4efb\u52a1\u6570\u91cf\uff1a[{}]", (Object)taskMap.size());
        if (taskMap.size() > 0) {
            ((Stream)taskMap.values().stream().parallel()).forEach(task -> {
                log.info("\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1\uff0c\u4efb\u52a1\u540d\u79f0\uff1a[{}],\u4efb\u52a1\u63cf\u8ff0\uff1a[{}]", (Object)task.taskName(), (Object)task.description());
                scheduleService.push((ScheduleTask)task);
            });
        }
    }
}

