/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.register.impl;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.param.ExecutorParam;
import com.bxm.newidea.component.schedule.register.ScheduleRegisterService;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleRegisterServiceImpl
implements ScheduleRegisterService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleRegisterServiceImpl.class);
    private XxlJobConfigurationProperties properties;

    public ScheduleRegisterServiceImpl(XxlJobConfigurationProperties properties) {
        this.properties = properties;
    }

    private String buildParam(ScheduleTask task) {
        return JSON.toJSONString((Object)new ExecutorParam(task.callback().beanName(), task.callbackParam()));
    }

    @Override
    public void add(ScheduleTask task) {
        String addUrl = this.buildPath("facade/jobInfo/add");
        Map<String, String> paramMap = this.createParamMap(task);
        String response = OkHttpUtils.postForm((String)addUrl, paramMap, null);
        log.info("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(paramMap), (Object)response);
    }

    private String buildPath(String uri) {
        if (StringUtils.endsWith((CharSequence)this.properties.getAdminAddresses(), (CharSequence)"/")) {
            return this.properties.getAdminAddresses() + uri;
        }
        return this.properties.getAdminAddresses() + "/" + uri;
    }

    private Map<String, String> createParamMap(ScheduleTask task) {
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("appName", this.properties.getAppName());
        paramMap.put("jobName", task.taskName());
        paramMap.put("jobCron", task.cron());
        paramMap.put("jobDesc", task.description());
        paramMap.put("executorName", task.taskName());
        paramMap.put("executorHandler", "beanByNameHandler");
        paramMap.put("executorParam", this.buildParam(task));
        paramMap.put("executorRouteStrategy", task.routeStrategy().name());
        paramMap.put("executorBlockStrategy", task.blockStrategy().name());
        paramMap.put("author", task.author());
        return paramMap;
    }

    @Override
    public void update(ScheduleTask task) {
        String addUrl = this.buildPath("facade/jobInfo/update");
        Map<String, String> paramMap = this.createParamMap(task);
        String response = OkHttpUtils.postForm((String)addUrl, paramMap, null);
        log.info("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(paramMap), (Object)response);
    }

    @Override
    public void remove(ScheduleTask task) {
        String addUrl = this.buildPath("facade/jobInfo/remove");
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("jobName", task.taskName());
        String response = OkHttpUtils.postForm((String)addUrl, (Map)paramMap, null);
        log.info("\u79fb\u9664\u5b9a\u65f6\u4efb\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)paramMap), (Object)response);
    }
}

