/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.service.impl;

import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.register.ScheduleRegisterService;
import com.bxm.newidea.component.schedule.service.ScheduleService;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    private ScheduleRegisterService scheduleRegisterService;
    private XxlJobConfigurationProperties properties;

    public ScheduleServiceImpl(ScheduleRegisterService scheduleRegisterService, XxlJobConfigurationProperties properties) {
        this.scheduleRegisterService = scheduleRegisterService;
        this.properties = properties;
    }

    @Override
    public String push(ScheduleTask task) {
        if (!this.validate(task)) {
            return null;
        }
        if (task.onceTask()) {
            this.scheduleRegisterService.update(task);
            return null;
        }
        this.scheduleRegisterService.add(task);
        return null;
    }

    @Override
    public void remove(ScheduleTask task) {
        this.scheduleRegisterService.remove(task);
    }

    private boolean validate(ScheduleTask task) {
        if (StringUtils.isBlank((String)task.taskName())) {
            log.error("\u4efb\u52a1\u540d\u672a\u914d\u7f6e");
            return false;
        }
        if (null == task.cron()) {
            log.error("\u4efb\u52a1\u672a\u8bbe\u7f6e\u6267\u884c\u65f6\u95f4");
            return false;
        }
        if (null == task.callback()) {
            log.error("\u4efb\u52a1\u56de\u8c03\u670d\u52a1\u7c7b\u672a\u8bbe\u7f6e");
            return false;
        }
        return true;
    }
}

