package com.bxm.newidea.component.zk.config;

import com.bxm.newidea.component.zk.service.ZookeeperAdapter;
import com.bxm.newidea.component.zk.service.impl.ZookeeperAdapterImpl;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryUntilElapsed;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * zookeeper的配置
 *
 * @author liujia
 * @date 6/7/21 9:23 AM
 **/
@Configuration
@EnableConfigurationProperties(ComponentZkConfigurationProperties.class)
public class ComponentZkConfiguration implements ApplicationRunner {

    private ComponentZkConfigurationProperties properties;

    private CuratorFramework curatorFramework;

    public ComponentZkConfiguration(ComponentZkConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(RetryPolicy.class)
    public RetryPolicy zkRetryPolicy() {
        return new RetryUntilElapsed(5000, 100);
    }

    @Bean
    @ConditionalOnMissingBean(CuratorFramework.class)
    @ConditionalOnProperty("component.zk.url")
    public CuratorFramework curatorFramework(RetryPolicy retryPolicy) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();

        builder.connectString(properties.getUrl())
                .connectionTimeoutMs(properties.getConnectionTimeout())
                .sessionTimeoutMs(properties.getSessionTimeout())
                .retryPolicy(retryPolicy);

        if (null != properties.getNamespace()) {
            builder.namespace(properties.getNamespace());
        }

        curatorFramework = builder.build();
        return curatorFramework;
    }

    @Bean
    @ConditionalOnMissingBean(ZookeeperAdapter.class)
    public ZookeeperAdapter zookeeperAdapter(CuratorFramework curatorFramework) {
        return new ZookeeperAdapterImpl(curatorFramework);
    }

    @Override
    public void run(ApplicationArguments args) {
        if (curatorFramework != null) {
            curatorFramework.start();
        }
    }
}
