package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@ApiModel("新闻评论实体")
@Data
public class AdminAllReplyParam extends PageParam {

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("新闻id")
    private Long newsId;

    @ApiModelProperty("回复人id")
    private Long replyUserId;

    @ApiModelProperty("回复人昵称")
    private String replyUserName;

    @ApiModelProperty("回复内容")
    private String replyContent;

    @ApiModelProperty("评论开始时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date replyStartTime;

    @ApiModelProperty("评论结束时间")
    @DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date replyEndTime;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("马甲号互动 ,0未互动,1已互动")
    private Byte vestInteract;

    @ApiModelProperty("是否用户删除 0运营删除,1用户删除")
    private Byte isUserDelete;

    private Byte deleteFlag;

    @ApiModelProperty("【3.12.0】评论状态 0: 待展示; 1: 已展示（审核通过）; 2: 待审核; 3: 审核拒绝; 4: 仅自己可见;" +
            " 105: 用户删除（伪造的状态）; 106: 运营删除（伪造的状态）")
    private Byte commentStatus;

}
