package com.bxm.localnews.news.model.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by Administrator on 2018/3/1 0001.
 */
@ApiModel(description = "我收到的新闻评论")
public class MyReceiveReplysVO extends BaseBean {

    @ApiModelProperty("评论id")
    private Long replyId;

    @ApiModelProperty("新闻id")
    private Long newsId;

    @ApiModelProperty("评论人的昵称")
    private String nickName;

    @ApiModelProperty("评论人头像地址")
    private String headImg;

    @ApiModelProperty("评论人id")
    private Long userId;

    @ApiModelProperty("我的昵称")
    private String parentNickName;

    @ApiModelProperty("我的头像")
    private String parentHeadImg;

    @ApiModelProperty("评论内容")
    private String replyContent;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("评论时间")
    @JSONField(format = DateUtils.DATE_TIME_FORMAT)
    private String addTime;

    @ApiModelProperty("时间戳")
    private Long addTimestamp;

    @ApiModelProperty("删除标记,1：表示该评论已删除")
    private byte deleteFlag;

    public byte getDeleteFlag() {
        return this.deleteFlag;
    }

    public void setDeleteFlag(byte deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAddTimestamp() {
        return this.addTimestamp;
    }

    public void setAddTimestamp(Long addTimestamp) {
        this.addTimestamp = addTimestamp;
    }

    public Long getReplyId() {
        return this.replyId;
    }

    public void setReplyId(Long replyId) {
        this.replyId = replyId;
    }

    public Long getNewsId() {
        return this.newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHeadImg() {
        return this.headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getParentNickName() {
        return this.parentNickName;
    }

    public void setParentNickName(String parentNickName) {
        this.parentNickName = parentNickName;
    }

    public String getParentHeadImg() {
        return this.parentHeadImg;
    }

    public void setParentHeadImg(String parentHeadImg) {
        this.parentHeadImg = parentHeadImg;
    }

    public String getReplyContent() {
        return this.replyContent;
    }

    public void setReplyContent(String replyContent) {
        this.replyContent = replyContent;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAddTime() {
        return this.addTime;
    }

    public void setAddTime(String addTime) {
        this.addTime = addTime;
    }

}


