package com.bxm.localnews.news.model.vo;

import com.bxm.localnews.news.model.dto.ReplyNewsDTO;
import com.bxm.localnews.news.model.dto.ReplyPostDTO;
import com.bxm.localnews.news.model.dto.ReplyVideoDTO;
import com.bxm.localnews.news.model.dto.UserWarmLevelDTO;
import com.bxm.localnews.news.model.dto.medal.SimpleMedalDTO;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "我的评论")
@Data
public class MyReplysVO extends BaseBean {

    @ApiModelProperty("评论id")
    private Long replyId;

    @ApiModelProperty("新闻id")
    private Long newsId;

    @ApiModelProperty("类型：1.新闻  2.小视频 3.帖子")
    private Byte type;

    @ApiModelProperty("新闻或者小视频封面 此字段为了向前兼容")
    private String newsImgUrl;

    @ApiModelProperty("昵称")
    private String nickName;

    @ApiModelProperty("头像")
    private String headImg;

    @ApiModelProperty("时间戳")
    private String addTimestamp;

    @ApiModelProperty("评论内容")
    private String replyContent;

    @ApiModelProperty("评论内容")
    @JsonIgnore
    private String replyContentHtml;

    @ApiModelProperty("【3.12.0】评论图片")
    private String replyImg;

    @ApiModelProperty("新闻或小视频标题")
    private String title;

    @ApiModelProperty("评论时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty("视频播放地址 此字段似乎没什么用")
    private String videoAddress;

    @ApiModelProperty("评论时间")
    private String replyTime;

    private ReplyNewsDTO replyNewsDto;

    private ReplyVideoDTO replyVideoDto;

    private ReplyPostDTO replyPostDto;

    @ApiModelProperty("3.12.0 用户温暖值等级信息")
    private UserWarmLevelDTO userWarmLevelDTO;

    @ApiModelProperty(value = "3.12.0 佩戴勋章列表")
    private List<SimpleMedalDTO> wearMedalList;
}
