package com.bxm.localnews.news.domain;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.localnews.news.model.entity.UserFollowEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 用户的关注关联关系 Mapper 接口
 * </p>
 *
 * @author liujia
 * @since 2021-09-29
 */
@Mapper
public interface UserFollowMapper extends BaseMapper<UserFollowEntity> {

    /**
     * 取消关注后移除用户ID
     *
     * @param userId         用户ID
     * @param unfollowUserId 取关的用户ID
     * @return 删除行数
     */
    int removeFollow(@Param("userId") Long userId, @Param("unfollowUserId") Long unfollowUserId);
}
