package com.bxm.localnews.converter;

import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.localnews.news.vo.UserBean;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author liujia
 * @date 9/29/21 2:17 PM
 **/
@Mapper
public interface IntegrationConverter {

    IntegrationConverter INSTANCE = Mappers.getMapper(IntegrationConverter.class);

    @Mappings({
            @Mapping(source = "userId", target = "id"),
            @Mapping(source = "userId", target = "nickname"),
    })
    UserBean of(UserInfoBO userInfo);

    @Mappings({
            @Mapping(source = "userId", target = "id"),
            @Mapping(source = "userId", target = "nickname"),
    })
    List<UserBean> of(List<UserInfoBO> userInfoList);
}
