package com.bxm.localnews.integration;

import com.bxm.egg.facade.service.LocationFacadeService;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.user.facade.service.UserEggAccountFacadeService;
import com.bxm.egg.user.facade.service.UserInfoFacadeService;
import com.bxm.egg.user.facade.service.UserWarmFacadeService;
import com.bxm.foundation.base.facade.service.DomainFacadeService;
import com.bxm.foundation.base.facade.service.SensitiveWordFacadeService;
import com.bxm.foundation.base.facade.service.ShortUrlFacadeService;
import com.bxm.foundation.user.facade.VirtualUserFacadeService;
import lombok.Getter;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * 统一声明内部服务的调用
 *
 * @author liujia
 * @date 9/15/21 12:48 PM
 **/
@Getter
@Service
public class InnerServiceIntegrationService {

    @DubboReference(protocol = "dubbo",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private MessageFacadeService messageFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private DomainFacadeService domainFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private ShortUrlFacadeService shortUrlFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private VirtualUserFacadeService virtualUserFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failfast",
            version = "1.0.0",
            mock = "com.bxm.localnews.integration.mock.SensitiveWordFacadeServiceMock",
            check = false,
            lazy = true
    )
    private SensitiveWordFacadeService sensitiveWordFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failfast",
            version = "1.0.0",
            mock = "com.bxm.egg.facade.mock.LocationFacadeServiceMock",
            check = false,
            lazy = true
    )
    private LocationFacadeService locationFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failfast",
            version = "1.0.0",
            mock = "com.bxm.egg.user.facade.mock.UserWarmFacadeServiceMock",
            check = false,
            lazy = true
    )
    private UserWarmFacadeService userWarmFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failfast",
            version = "1.0.0",
            mock = "com.bxm.egg.user.facade.mock.UserInfoFacadeServiceMock",
            check = false,
            lazy = true
    )
    private UserInfoFacadeService userInfoFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failfast",
            version = "1.0.0",
            mock = "com.bxm.egg.user.facade.mock.UserEggAccountFacadeServiceMock",
            check = false,
            lazy = true
    )
    private UserEggAccountFacadeService userEggAccountFacadeService;
}
