package com.bxm.localnews.integration;

import com.bxm.egg.user.enums.OperateTypeEnum;
import com.bxm.egg.user.facade.param.UserEggOperateFoodsParam;
import com.bxm.egg.user.facade.service.UserEggAccountFacadeService;
import org.springframework.stereotype.Component;

/**
 * @author liujia
 * @date 9/29/21 3:21 PM
 **/
@Component
public class UserAccountIntegraionService {

    private UserEggAccountFacadeService userEggAccountFacadeService;

    public UserAccountIntegraionService(InnerServiceIntegrationService innerServiceIntegrationService) {
        this.userEggAccountFacadeService = innerServiceIntegrationService.getUserEggAccountFacadeService();
    }

    /**
     * 用户领取粮食
     *
     * @param userId     用户ID
     * @param grainNum   粮食数量
     * @param relationId 关联的内容ID
     * @return 添加是否成功
     */
    public boolean addGrain(Long userId, Integer grainNum, Long relationId) {
        UserEggOperateFoodsParam param = new UserEggOperateFoodsParam();
        param.setUserId(userId);
        param.setRemark("开仓放粮领取粮食");
        param.setGoodsNum(grainNum);
        param.setOperateTypeEnum(OperateTypeEnum.INCREASE);

        return userEggAccountFacadeService.operateFoods(param).isSuccess();
    }
}
